/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.Address;
import Freenet.Connection;
import Freenet.Core;
import Freenet.ListeningAddress;
import Freenet.crypt.EntropySource;
import Freenet.servlet.Servlet;
import Freenet.servlet.ServletException;
import Freenet.servlet.ServletRequest;
import Freenet.servlet.util.FreenetServletRequest;
import Freenet.servlet.util.FreenetServletResponse;
import Freenet.support.Logger;
import Freenet.thread.ERunnable;
import Freenet.thread.EThread;
import java.io.IOException;
import java.io.OutputStream;

public class ServletConnectionHandler
implements ERunnable {
    private static int highid = 32769;
    private Connection c;
    private Servlet service;
    private int id;
    private volatile long lastActiveTime;
    private volatile boolean closeOnInactive = false;
    private volatile boolean closed;
    private volatile boolean writing = false;
    private boolean persist = false;
    private Thread exec_instance;
    private static EntropySource sendTimer = new EntropySource();
    private static EntropySource recvTimer = new EntropySource();
    public Object initLock = new Object();
    public Object sendLock = new Object();
    public boolean ready;

    public ServletConnectionHandler(Connection connection, Servlet servlet) {
        this.id = highid++;
        if (highid > 65536) {
            highid = 32769;
        }
        this.c = connection;
        this.service = servlet;
        this.lastActiveTime = System.currentTimeMillis();
        Core.logger.log(this, "New ServletConnectionHandler with " + this.peer(), Logger.DEBUGGING);
    }

    public void start() {
        this.exec_instance = new Thread((Runnable)this, this.peer() + " ServletConnectionHandler");
        this.exec_instance.start();
    }

    public void setExecutionInstance(EThread eThread) {
        this.exec_instance = eThread.getThread();
    }

    public void run() {
        Object object;
        Object object2;
        Object object3 = this.sendLock;
        synchronized (object3) {
            Core.logger.log(this, "Authenticating " + this.c, Logger.MINOR);
            this.ready = true;
            Core.logger.log(this, this.c + " authenticated", Logger.MINOR);
            this.sendLock.notifyAll();
            object2 = this.c.initLock;
            synchronized (object2) {
                this.c.initLock.notifyAll();
            }
            object = this.initLock;
            synchronized (object) {
                this.initLock.notifyAll();
            }
        }
        this.c.setReady();
        object2 = this.c.getPeerAddress() + " <- " + this.c.getPeerAddress();
        System.out.println((String)object2);
        object = new FreenetServletRequest(this.c.in);
        FreenetServletResponse freenetServletResponse = new FreenetServletResponse(this.c.out);
        try {
            this.service.service((ServletRequest)object, freenetServletResponse);
        }
        catch (ServletException servletException) {
            servletException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Core.logger.log(this, "Finished with message", Logger.DEBUGGING);
        this.lastActiveTime = System.currentTimeMillis();
        if (this.c.out != null) {
            OutputStream outputStream = this.c.out;
            synchronized (outputStream) {
                Core.logger.log(this, "Finished with connection - closing", Logger.DEBUGGING);
                this.forceClose();
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public void forceClose() {
        this.closed = true;
        this.c.close();
        this.exec_instance.interrupt();
    }

    public boolean isOpen() {
        return this.exec_instance.isAlive() && !this.closed;
    }

    public Address peer() {
        return this.c.getPeerAddress();
    }

    public Address peer(ListeningAddress listeningAddress) {
        return this.c.getPeerAddress(listeningAddress);
    }

    public Address local() {
        return this.c.getMyAddress();
    }

    public Address local(ListeningAddress listeningAddress) {
        return this.c.getMyAddress(listeningAddress);
    }
}

