/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.BlockCipher;
import Freenet.crypt.CipherInputStream;
import Freenet.crypt.CipherOutputStream;
import Freenet.crypt.DiffieHellman;
import Freenet.crypt.Global;
import Freenet.crypt.KEProtocol;
import Freenet.crypt.RandomSource;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import Freenet.crypt.ciphers.Rijndael;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class CipherLink {
    private CipherInputStream s_in;
    private CipherOutputStream s_out;

    public CipherLink(RandomSource randomSource, KEProtocol kEProtocol, BlockCipher blockCipher, InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[blockCipher.getKeySize() >> 3];
        kEProtocol.negotiateKey(inputStream, outputStream, byArray, 0, byArray.length);
        blockCipher.initialize(byArray);
        this.s_out = new CipherOutputStream(randomSource, blockCipher, outputStream);
        this.s_in = new CipherInputStream(blockCipher, inputStream);
        Util.wipe(byArray);
    }

    public InputStream getInputStream() {
        return this.s_in;
    }

    public OutputStream getOutputStream() {
        return this.s_out;
    }

    public static void main(String[] stringArray) throws Exception {
        Closeable closeable;
        Yarrow yarrow = new Yarrow();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        Socket socket = null;
        if (stringArray.length == 0) {
            closeable = new ServerSocket(20204);
            socket = ((ServerSocket)closeable).accept();
        } else {
            socket = new Socket(stringArray[0], 20204);
        }
        inputStream = socket.getInputStream();
        outputStream = socket.getOutputStream();
        Rijndael rijndael = new Rijndael();
        CipherLink cipherLink = new CipherLink(yarrow, new DiffieHellman(Global.DHgroupA, yarrow), rijndael, inputStream, outputStream);
        closeable = cipherLink.getInputStream();
        OutputStream outputStream2 = cipherLink.getOutputStream();
        byte[] byArray = new byte[65536];
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = 1;
        while (n2 > 0) {
            if (stringArray.length == 0) {
                n2 = System.in.read(byArray);
                if (n2 <= 0) continue;
                n += n2;
                outputStream2.write(byArray, 0, n2);
                outputStream2.flush();
                continue;
            }
            n2 = ((InputStream)closeable).read(byArray);
            if (n2 <= 0) continue;
            n += n2;
            System.out.write(byArray, 0, n2);
        }
        outputStream2.flush();
        System.out.flush();
        long l2 = System.currentTimeMillis() - l;
        System.err.println(n + " bytes (" + (long)n / l2 + " bytes/ms)");
    }
}

