/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.CryptoKey;
import Freenet.crypt.DSAGroup;
import Freenet.crypt.Global;
import Freenet.crypt.KeyPair;
import Freenet.crypt.Yarrow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAKeyPair
extends KeyPair {
    public DSAKeyPair(DSAGroup dSAGroup, BigInteger bigInteger) {
        super(null, new BigInteger[]{bigInteger}, dSAGroup);
    }

    public DSAKeyPair(BigInteger bigInteger, DSAGroup dSAGroup) {
        super(new BigInteger[]{bigInteger}, new BigInteger[]{dSAGroup.getG().modPow(bigInteger, dSAGroup.getP())}, dSAGroup);
    }

    public static KeyPair read(DataInputStream dataInputStream, CryptoKey cryptoKey) throws IOException {
        BigInteger[][] bigIntegerArray = KeyPair.readKeys(dataInputStream);
        return new DSAKeyPair(bigIntegerArray[0][0], (DSAGroup)cryptoKey);
    }

    public void write(OutputStream outputStream) throws IOException {
        super.write(new DataOutputStream(outputStream), this.getClass().getName());
    }

    public String keyType() {
        return "DSA-1024";
    }

    public DSAGroup getGroup() {
        return (DSAGroup)this.dependent;
    }

    public BigInteger getP() {
        return this.getGroup().getP();
    }

    public BigInteger getQ() {
        return this.getGroup().getQ();
    }

    public BigInteger getG() {
        return this.getGroup().getG();
    }

    public BigInteger getX() {
        return this.x[0];
    }

    public BigInteger getY() {
        return this.y[0];
    }

    public static void main(String[] stringArray) throws Exception {
        DSAKeyPair dSAKeyPair = null;
        if (stringArray[0].equals("read")) {
            File file = new File(stringArray[1]);
            dSAKeyPair = (DSAKeyPair)CryptoKey.read(new FileInputStream(file));
        } else {
            File file = new File(stringArray[0]);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            dSAKeyPair = new DSAKeyPair(new BigInteger(160, new Yarrow()), Global.DSAgroupA);
            dSAKeyPair.write(fileOutputStream);
            fileOutputStream.close();
        }
        System.err.println(dSAKeyPair.verboseToString());
    }
}

