/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.Core;
import Freenet.crypt.DSA;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.DSASignature;
import Freenet.crypt.Digest;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.support.Logger;
import Freenet.support.io.ControlInputStream;
import Freenet.support.io.DataNotValidIOException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DSSVerifyingInputStream
extends ControlInputStream {
    protected Digest ctx;
    protected DSAKeyPair kp;
    protected DSASignature signature;
    protected int pushBack = -1;

    public DSSVerifyingInputStream(InputStream inputStream, DSAKeyPair dSAKeyPair, DSASignature dSASignature, long l) {
        this(inputStream, dSAKeyPair, dSASignature, l, new SHA1());
    }

    public DSSVerifyingInputStream(InputStream inputStream, DSAKeyPair dSAKeyPair, DSASignature dSASignature, long l, Digest digest) {
        super(inputStream, 0L, l);
        this.ctx = digest;
        this.kp = dSAKeyPair;
        this.signature = dSASignature;
        this.stripControls(false);
    }

    public int read() throws IOException, DataNotValidIOException {
        return this.priv_read();
    }

    private int priv_read() throws IOException, DataNotValidIOException {
        int n = super.read();
        if (n != -1 && !this.finished) {
            this.ctx.update((byte)n);
        }
        if (!this.finished && this.stripControls && this.allRead) {
            this.priv_read();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.ctx.update(byArray, n, n3);
            if (this.finished && n3 > 1 && this.stripControls) {
                --n3;
            } else if (this.finished && this.stripControls) {
                n3 = -1;
            }
        }
        if (!this.finished && this.stripControls && this.allRead) {
            this.priv_read();
        }
        return n3;
    }

    public void checkPart(int n) throws IOException, DataNotValidIOException {
        super.checkPart(n);
        byte[] byArray = this.ctx.digest();
        BigInteger bigInteger = Util.byteArrayToMPI(byArray);
        if (!DSA.verify(this.kp, this.signature, bigInteger)) {
            Core.logger.log(this, "Failed verification", Logger.DEBUGGING);
            throw new DataNotValidIOException(n);
        }
        Core.logger.log(this, "Verified successfully", Logger.DEBUGGING);
    }
}

