/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.DHGroup;
import Freenet.crypt.Global;
import Freenet.crypt.KEProtocol;
import Freenet.crypt.RandomSource;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Stack;

public class DiffieHellman
extends KEProtocol {
    private DHGroup group;
    private int precalc;
    private Stack precalcBuffer;

    public DiffieHellman(DHGroup dHGroup, RandomSource randomSource) {
        this(dHGroup, randomSource, 0);
    }

    public DiffieHellman(DHGroup dHGroup, RandomSource randomSource, int n) {
        super(randomSource);
        this.group = dHGroup;
        this.precalc = n;
        if (n > 0) {
            this.precalcBuffer = new Stack();
            new PrecalcBufferFill().start();
        }
    }

    private BigInteger[] getParams() {
        if (this.precalc > 0) {
            Stack stack = this.precalcBuffer;
            synchronized (stack) {
                if (!this.precalcBuffer.isEmpty()) {
                    BigInteger[] bigIntegerArray = (BigInteger[])this.precalcBuffer.pop();
                    return bigIntegerArray;
                }
            }
        }
        return this.genParams();
    }

    private BigInteger[] genParams() {
        BigInteger[] bigIntegerArray;
        bigIntegerArray = new BigInteger[]{Util.generateLargeRandom(128, 256, this.randomSource), this.group.getG().modPow(bigIntegerArray[0], this.group.getP())};
        return bigIntegerArray;
    }

    private BigInteger negotiate(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        this.randomSource.acceptTimerEntropy(this.es);
        BigInteger[] bigIntegerArray = this.getParams();
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        Util.writeMPI(bigInteger2, outputStream);
        BigInteger bigInteger3 = Util.readMPI(inputStream);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, this.group.getP());
        this.randomSource.acceptTimerEntropy(this.es);
        return bigInteger4;
    }

    public void negotiateKey(InputStream inputStream, OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = Util.MPIbytes(this.negotiate(inputStream, outputStream, n2 << 3));
        Util.makeKey(byArray2, byArray, n, n2);
    }

    public static void main(String[] stringArray) throws Exception {
        long l;
        Yarrow yarrow = new Yarrow();
        DiffieHellman diffieHellman = new DiffieHellman(Global.DHgroupA, yarrow);
        int n = 45;
        Socket socket = null;
        ServerSocket serverSocket = null;
        if (stringArray.length == 1) {
            serverSocket = new ServerSocket(Integer.parseInt(stringArray[0]));
        }
        if ((l = 0L) == 0L) {
            l = System.currentTimeMillis();
        }
        socket = stringArray.length == 1 ? serverSocket.accept() : new Socket(stringArray[0], Integer.parseInt(stringArray[1]));
        InputStream inputStream = socket.getInputStream();
        PrintStream printStream = new PrintStream(socket.getOutputStream());
        byte[] byArray = new byte[16];
        int n2 = 0;
        while (n2 < n) {
            diffieHellman.negotiateKey(inputStream, printStream, byArray, 0, byArray.length);
            int n3 = 0;
            while (n3 < byArray.length) {
                String string = Integer.toHexString(byArray[n3]);
                if (string.length() > 1) {
                    System.err.print(string.substring(string.length() - 2, string.length()));
                } else {
                    System.err.print('0' + string);
                }
                ++n3;
            }
            System.err.println();
            ++n2;
        }
        System.out.println((double)(System.currentTimeMillis() - l) / (double)n);
    }

    private class PrecalcBufferFill
    extends Thread {
        public PrecalcBufferFill() {
            this.setName("Diffie-Helman-Precalc");
            this.setDaemon(true);
            this.setPriority(1);
        }

        public void run() {
            while (true) {
                if (DiffieHellman.this.precalcBuffer.size() < DiffieHellman.this.precalc) {
                    DiffieHellman.this.precalcBuffer.push(DiffieHellman.this.genParams());
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

