/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.CryptoKey;
import Freenet.crypt.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public abstract class KeyPair
extends CryptoKey {
    protected final BigInteger[] x;
    protected final BigInteger[] y;

    public KeyPair(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2, CryptoKey cryptoKey) {
        super(cryptoKey);
        this.x = bigIntegerArray == null ? new BigInteger[]{} : bigIntegerArray;
        this.y = bigIntegerArray2 == null ? new BigInteger[]{} : bigIntegerArray2;
    }

    public KeyPair(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        this(bigIntegerArray, bigIntegerArray2, null);
    }

    protected static BigInteger[][] readKeys(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        BigInteger[] bigIntegerArray = new BigInteger[n2];
        BigInteger[] bigIntegerArray2 = new BigInteger[n];
        int n3 = 0;
        while (n3 < bigIntegerArray2.length) {
            bigIntegerArray2[n3] = Util.readMPI(dataInputStream);
            ++n3;
        }
        int n4 = 0;
        while (n4 < bigIntegerArray.length) {
            bigIntegerArray[n4] = Util.readMPI(dataInputStream);
            ++n4;
        }
        return new BigInteger[][]{bigIntegerArray, bigIntegerArray2};
    }

    public void write(DataOutputStream dataOutputStream, String string) throws IOException {
        super.write(dataOutputStream, string);
        dataOutputStream.write(this.y.length);
        dataOutputStream.write(this.x.length);
        int n = 0;
        while (n < this.y.length) {
            Util.writeMPI(this.y[n], dataOutputStream);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.x.length) {
            Util.writeMPI(this.x[n2], dataOutputStream);
            ++n2;
        }
    }

    public BigInteger[] getPublicComponents() {
        return this.y;
    }

    public BigInteger[] getPrivateComponents() {
        return this.x;
    }

    public byte[] fingerprint() {
        return this.fingerprint(this.getPublicComponents());
    }
}

