/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.Core;
import Freenet.crypt.CryptoKey;
import Freenet.crypt.RSAKeyPair;
import Freenet.crypt.RSASignature;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import Freenet.support.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Random;

public class RSA {
    public static BigInteger rsa_algo(RSAKeyPair rSAKeyPair, BigInteger bigInteger, boolean bl) {
        if (bigInteger.bitLength() > rSAKeyPair.getN().bitLength()) {
            Core.logger.log(new RSA(), "Warning in RSA: Message size exceeds key size\n", Logger.ERROR);
        }
        if (bl) {
            if (rSAKeyPair.getP() != null) {
                BigInteger bigInteger2 = bigInteger.modPow(rSAKeyPair.getDmodPsub1(), rSAKeyPair.getP());
                BigInteger bigInteger3 = bigInteger.modPow(rSAKeyPair.getDmodQsub1(), rSAKeyPair.getQ());
                BigInteger bigInteger4 = bigInteger2.multiply(rSAKeyPair.getQinvmodP()).multiply(rSAKeyPair.getQ()).add(bigInteger3.multiply(rSAKeyPair.getPinvmodQ()).multiply(rSAKeyPair.getP())).mod(rSAKeyPair.getN());
                return bigInteger4;
            }
            return bigInteger.modPow(rSAKeyPair.getD(), rSAKeyPair.getN());
        }
        return bigInteger.modPow(rSAKeyPair.getE(), rSAKeyPair.getN());
    }

    public static BigInteger encrypt(RSAKeyPair rSAKeyPair, BigInteger bigInteger) {
        return RSA.rsa_algo(rSAKeyPair, bigInteger, false);
    }

    public static BigInteger decrypt(RSAKeyPair rSAKeyPair, BigInteger bigInteger) {
        return RSA.rsa_algo(rSAKeyPair, bigInteger, true);
    }

    public static BigInteger sign(RSAKeyPair rSAKeyPair, Random random, byte[] byArray) {
        BigInteger bigInteger = RSA.wrap(rSAKeyPair, random, byArray);
        return RSA.decrypt(rSAKeyPair, bigInteger);
    }

    public static boolean verify(RSAKeyPair rSAKeyPair, BigInteger bigInteger, byte[] byArray) {
        BigInteger bigInteger2 = RSA.encrypt(rSAKeyPair, bigInteger);
        byte[] byArray2 = RSA.unwrap(bigInteger2);
        return Util.byteArrayEqual(byArray2, byArray);
    }

    public static BigInteger wrap(RSAKeyPair rSAKeyPair, Random random, byte[] byArray) {
        int n = rSAKeyPair.getN().bitLength();
        byte[] byArray2 = new byte[n >> 3];
        random.nextBytes(byArray2);
        byArray2[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return Util.byteArrayToMPI(byArray2);
    }

    public static byte[] unwrap(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        byte by = byArray[0];
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, 1, byArray2, 0, by);
        return byArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        Yarrow yarrow = new Yarrow();
        SHA1 sHA1 = new SHA1();
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        RSAKeyPair rSAKeyPair = (RSAKeyPair)CryptoKey.read(fileInputStream);
        byte[] byArray = Util.hashFile(sHA1, file);
        if (stringArray.length == 4 && stringArray[3].equals("test")) {
            BigInteger bigInteger = Util.TWO;
            System.err.println(bigInteger.toString(16));
            BigInteger bigInteger2 = RSA.encrypt(rSAKeyPair, bigInteger);
            System.err.println(bigInteger2.toString(16));
            bigInteger = RSA.decrypt(rSAKeyPair, bigInteger2);
            System.err.println(bigInteger.toString(16));
            return;
        }
        if (stringArray.length == 4 && stringArray[3].equals("sign")) {
            long l = System.currentTimeMillis();
            RSASignature rSASignature = null;
            int n = 0;
            while (n < 2000) {
                rSASignature = new RSASignature(RSA.sign(rSAKeyPair, yarrow, byArray));
                ++n;
            }
            System.out.println("Time:" + (System.currentTimeMillis() - l));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            rSASignature.write(fileOutputStream);
            fileOutputStream.close();
        } else {
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            RSASignature rSASignature = new RSASignature(fileInputStream2);
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 2000) {
                RSA.verify(rSAKeyPair, rSASignature.getS(), byArray);
                ++n;
            }
            System.out.println("Time:" + (System.currentTimeMillis() - l));
            System.err.println(RSA.verify(rSAKeyPair, rSASignature.getS(), byArray));
        }
    }
}

