/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSASignature {
    private final BigInteger m;

    public RSASignature(InputStream inputStream) throws IOException {
        this.m = Util.readMPI(inputStream);
    }

    public RSASignature(String string) {
        this.m = Util.byteArrayToMPI(Util.hexToBytes(string));
    }

    public void write(OutputStream outputStream) throws IOException {
        Util.writeMPI(this.m, outputStream);
    }

    public RSASignature(BigInteger bigInteger) {
        this.m = bigInteger;
    }

    public BigInteger getS() {
        return this.m;
    }

    public String toString() {
        return this.m.toString(16).toLowerCase();
    }
}

