/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.Digest;

public final class SHA1
implements Digest {
    private int[] state = new int[5];
    private long count = 0L;
    private boolean digestValid = false;
    private byte[] digestBits;
    private boolean NSA = true;
    private int[] block = new int[16];
    private int blockIndex;
    private int[] dd = new int[5];

    public int digestSize() {
        return 160;
    }

    public String doHash(String string) {
        this.init();
        int n = 0;
        while (n < string.length()) {
            this.update((byte)string.charAt(n));
            ++n;
        }
        this.finish();
        return this.digout();
    }

    public void extract(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < 5) {
            nArray[n2 + n] = this.digestBits[4 * n2 + 0] << 24 & 0xFF000000 | this.digestBits[4 * n2 + 1] << 16 & 0xFF0000 | this.digestBits[4 * n2 + 2] << 8 & 0xFF00 | this.digestBits[4 * n2 + 3] & 0xFF;
            ++n2;
        }
    }

    public SHA1(boolean bl) {
        this.NSA = bl;
        this.init();
    }

    public SHA1() {
        this(true);
    }

    private final int rol(int n, int n2) {
        int n3 = n << n2 | n >>> 32 - n2;
        return n3;
    }

    private final int blk0(int n) {
        this.block[n] = this.rol(this.block[n], 24) & 0xFF00FF00 | this.rol(this.block[n], 8) & 0xFF00FF;
        return this.block[n];
    }

    private final int blk(int n) {
        this.block[n & 0xF] = this.block[n + 13 & 0xF] ^ this.block[n + 8 & 0xF] ^ this.block[n + 2 & 0xF] ^ this.block[n & 0xF];
        if (this.NSA) {
            this.block[n & 0xF] = this.rol(this.block[n & 0xF], 1);
        }
        return this.block[n & 0xF];
    }

    private final void R0(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk0(n6) + 1518500249 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk(n6) + 1518500249 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R2(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + 1859775393 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R3(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + (((nArray[n2] | nArray[n3]) & nArray[n4] | nArray[n2] & nArray[n3]) + this.blk(n6) + -1894007588 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private final void R4(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + -899497514 + this.rol(nArray[n], 5));
        nArray[n2] = this.rol(nArray[n2], 30);
    }

    private void transform() {
        this.dd[0] = this.state[0];
        this.dd[1] = this.state[1];
        this.dd[2] = this.state[2];
        this.dd[3] = this.state[3];
        this.dd[4] = this.state[4];
        this.R0(this.dd, 0, 1, 2, 3, 4, 0);
        this.R0(this.dd, 4, 0, 1, 2, 3, 1);
        this.R0(this.dd, 3, 4, 0, 1, 2, 2);
        this.R0(this.dd, 2, 3, 4, 0, 1, 3);
        this.R0(this.dd, 1, 2, 3, 4, 0, 4);
        this.R0(this.dd, 0, 1, 2, 3, 4, 5);
        this.R0(this.dd, 4, 0, 1, 2, 3, 6);
        this.R0(this.dd, 3, 4, 0, 1, 2, 7);
        this.R0(this.dd, 2, 3, 4, 0, 1, 8);
        this.R0(this.dd, 1, 2, 3, 4, 0, 9);
        this.R0(this.dd, 0, 1, 2, 3, 4, 10);
        this.R0(this.dd, 4, 0, 1, 2, 3, 11);
        this.R0(this.dd, 3, 4, 0, 1, 2, 12);
        this.R0(this.dd, 2, 3, 4, 0, 1, 13);
        this.R0(this.dd, 1, 2, 3, 4, 0, 14);
        this.R0(this.dd, 0, 1, 2, 3, 4, 15);
        this.R1(this.dd, 4, 0, 1, 2, 3, 16);
        this.R1(this.dd, 3, 4, 0, 1, 2, 17);
        this.R1(this.dd, 2, 3, 4, 0, 1, 18);
        this.R1(this.dd, 1, 2, 3, 4, 0, 19);
        this.R2(this.dd, 0, 1, 2, 3, 4, 20);
        this.R2(this.dd, 4, 0, 1, 2, 3, 21);
        this.R2(this.dd, 3, 4, 0, 1, 2, 22);
        this.R2(this.dd, 2, 3, 4, 0, 1, 23);
        this.R2(this.dd, 1, 2, 3, 4, 0, 24);
        this.R2(this.dd, 0, 1, 2, 3, 4, 25);
        this.R2(this.dd, 4, 0, 1, 2, 3, 26);
        this.R2(this.dd, 3, 4, 0, 1, 2, 27);
        this.R2(this.dd, 2, 3, 4, 0, 1, 28);
        this.R2(this.dd, 1, 2, 3, 4, 0, 29);
        this.R2(this.dd, 0, 1, 2, 3, 4, 30);
        this.R2(this.dd, 4, 0, 1, 2, 3, 31);
        this.R2(this.dd, 3, 4, 0, 1, 2, 32);
        this.R2(this.dd, 2, 3, 4, 0, 1, 33);
        this.R2(this.dd, 1, 2, 3, 4, 0, 34);
        this.R2(this.dd, 0, 1, 2, 3, 4, 35);
        this.R2(this.dd, 4, 0, 1, 2, 3, 36);
        this.R2(this.dd, 3, 4, 0, 1, 2, 37);
        this.R2(this.dd, 2, 3, 4, 0, 1, 38);
        this.R2(this.dd, 1, 2, 3, 4, 0, 39);
        this.R3(this.dd, 0, 1, 2, 3, 4, 40);
        this.R3(this.dd, 4, 0, 1, 2, 3, 41);
        this.R3(this.dd, 3, 4, 0, 1, 2, 42);
        this.R3(this.dd, 2, 3, 4, 0, 1, 43);
        this.R3(this.dd, 1, 2, 3, 4, 0, 44);
        this.R3(this.dd, 0, 1, 2, 3, 4, 45);
        this.R3(this.dd, 4, 0, 1, 2, 3, 46);
        this.R3(this.dd, 3, 4, 0, 1, 2, 47);
        this.R3(this.dd, 2, 3, 4, 0, 1, 48);
        this.R3(this.dd, 1, 2, 3, 4, 0, 49);
        this.R3(this.dd, 0, 1, 2, 3, 4, 50);
        this.R3(this.dd, 4, 0, 1, 2, 3, 51);
        this.R3(this.dd, 3, 4, 0, 1, 2, 52);
        this.R3(this.dd, 2, 3, 4, 0, 1, 53);
        this.R3(this.dd, 1, 2, 3, 4, 0, 54);
        this.R3(this.dd, 0, 1, 2, 3, 4, 55);
        this.R3(this.dd, 4, 0, 1, 2, 3, 56);
        this.R3(this.dd, 3, 4, 0, 1, 2, 57);
        this.R3(this.dd, 2, 3, 4, 0, 1, 58);
        this.R3(this.dd, 1, 2, 3, 4, 0, 59);
        this.R4(this.dd, 0, 1, 2, 3, 4, 60);
        this.R4(this.dd, 4, 0, 1, 2, 3, 61);
        this.R4(this.dd, 3, 4, 0, 1, 2, 62);
        this.R4(this.dd, 2, 3, 4, 0, 1, 63);
        this.R4(this.dd, 1, 2, 3, 4, 0, 64);
        this.R4(this.dd, 0, 1, 2, 3, 4, 65);
        this.R4(this.dd, 4, 0, 1, 2, 3, 66);
        this.R4(this.dd, 3, 4, 0, 1, 2, 67);
        this.R4(this.dd, 2, 3, 4, 0, 1, 68);
        this.R4(this.dd, 1, 2, 3, 4, 0, 69);
        this.R4(this.dd, 0, 1, 2, 3, 4, 70);
        this.R4(this.dd, 4, 0, 1, 2, 3, 71);
        this.R4(this.dd, 3, 4, 0, 1, 2, 72);
        this.R4(this.dd, 2, 3, 4, 0, 1, 73);
        this.R4(this.dd, 1, 2, 3, 4, 0, 74);
        this.R4(this.dd, 0, 1, 2, 3, 4, 75);
        this.R4(this.dd, 4, 0, 1, 2, 3, 76);
        this.R4(this.dd, 3, 4, 0, 1, 2, 77);
        this.R4(this.dd, 2, 3, 4, 0, 1, 78);
        this.R4(this.dd, 1, 2, 3, 4, 0, 79);
        this.state[0] = this.state[0] + this.dd[0];
        this.state[1] = this.state[1] + this.dd[1];
        this.state[2] = this.state[2] + this.dd[2];
        this.state[3] = this.state[3] + this.dd[3];
        this.state[4] = this.state[4] + this.dd[4];
    }

    public void frob() {
        this.count = 0L;
        this.state[4] = 0;
        this.state[3] = 0;
        this.state[2] = 0;
        this.state[1] = 0;
        this.state[0] = 0;
    }

    protected void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.count = 0L;
        this.digestBits = new byte[20];
        this.digestValid = false;
        this.blockIndex = 0;
    }

    public synchronized void update(byte by) {
        int n = (this.blockIndex & 3) << 3;
        this.count += 8L;
        int n2 = this.blockIndex >> 2;
        this.block[n2] = this.block[n2] & ~(255 << n);
        int n3 = this.blockIndex >> 2;
        this.block[n3] = this.block[n3] | (by & 0xFF) << n;
        ++this.blockIndex;
        if (this.blockIndex == 64) {
            this.transform();
            this.blockIndex = 0;
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.update(byArray[n + n3]);
            ++n3;
        }
    }

    public void digest(boolean bl, byte[] byArray, int n) {
        this.finish();
        System.arraycopy(this.digestBits, 0, byArray, n, this.digestBits.length);
        if (bl) {
            this.init();
        }
    }

    public byte[] digest(boolean bl) {
        byte[] byArray = new byte[20];
        this.digest(bl, byArray, 0);
        return byArray;
    }

    public byte[] digest() {
        return this.digest(true);
    }

    protected void finish() {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(this.count >>> (7 - n << 3) & 0xFFL);
            ++n;
        }
        this.update((byte)-128);
        while (this.blockIndex != 56) {
            this.update((byte)0);
        }
        n = 0;
        while (n < 8) {
            this.update(byArray[n]);
            ++n;
        }
        n = 0;
        while (n < 20) {
            this.digestBits[n] = (byte)(this.state[n >> 2] >>> (3 - (n & 3) << 3) & 0xFF);
            ++n;
        }
        this.digestValid = true;
    }

    protected String digout() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 20) {
            char c = (char)(this.digestBits[n] >>> 4 & 0xF);
            char c2 = (char)(this.digestBits[n] & 0xF);
            c = c > '\t' ? (char)(65 + (c - 10)) : (char)(48 + c);
            c2 = c2 > '\t' ? (char)(65 + (c2 - 10)) : (char)(48 + c2);
            stringBuffer.append(c);
            stringBuffer.append(c2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        SHA1.SHAselfTest();
    }

    public static void SHAselfTest() {
        SHA1 sHA1 = new SHA1(true);
        System.out.println("SHA-1 Test PROGRAM.");
        System.out.println("This code runs the test vectors through the code.");
        System.out.println("First test is 'abc'");
        String string = "abc";
        sHA1.init();
        sHA1.update((byte)97);
        sHA1.update((byte)98);
        sHA1.update((byte)99);
        sHA1.finish();
        System.out.println(sHA1.digout());
        System.out.println("A9993E364706816ABA3E25717850C26C9CD0D89D");
        System.out.println("Next Test is 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'");
        string = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
        sHA1.init();
        int n = 0;
        while (n < string.length()) {
            sHA1.update((byte)string.charAt(n));
            ++n;
        }
        sHA1.finish();
        System.out.println(sHA1.digout());
        System.out.println("84983E441C3BD26EBAAE4AA1F95129E5E54670F1");
        long l = 0L - System.currentTimeMillis();
        System.out.println("Last test is 1 million 'a' characters.");
        sHA1.init();
        n = 0;
        while (n < 1000000) {
            sHA1.update((byte)97);
            ++n;
        }
        sHA1.finish();
        System.out.println(sHA1.digout());
        System.out.println("34AA973CD4C4DAA4F61EEB2BDBAD27316534016F");
        double d = (double)(l += System.currentTimeMillis()) / 1000.0;
        System.out.println(" done, elapsed time = " + d);
    }
}

