/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt;

import Freenet.crypt.BlockCipher;
import Freenet.crypt.Digest;
import Freenet.crypt.EntropySource;
import Freenet.crypt.RandFile;
import Freenet.crypt.RandomSource;
import Freenet.crypt.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class Yarrow
extends RandomSource {
    private static final boolean DEBUG = false;
    private static final int Pg = 10;
    private String seedfile;
    private BlockCipher cipher_ctx;
    private byte[] output_buffer;
    private byte[] counter;
    private byte[] allZeroString;
    private byte[] tmp;
    private int output_count;
    private int fetch_counter;
    private int block_bytes;
    static final int[][] bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};
    private Digest fast_pool;
    private Digest slow_pool;
    private int fast_entropy;
    private int slow_entropy;
    private int digestSize;
    private boolean fast_select;
    private byte[] long_buffer = new byte[8];
    private Hashtable entropySeen;
    private static final int Pt = 5;
    private Digest reseed_ctx;
    private static final int FAST_THRESHOLD = 100;
    private static final int SLOW_THRESHOLD = 160;
    private static final int SLOW_K = 2;

    public Yarrow() {
        this("prng.seed", "SHA1", "Rijndael");
    }

    public Yarrow(String string, String string2, String string3) {
        this.accumulator_init(string2);
        this.reseed_init(string2);
        this.seedfile = string;
        this.generator_init(string3);
        this.entropy_init(string);
    }

    private void entropy_init(String string) {
        Properties properties = System.getProperties();
        EntropySource entropySource = new EntropySource();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.consumeString(string2);
            this.consumeString(properties.getProperty(string2));
        }
        try {
            this.consumeString(InetAddress.getLocalHost().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.acceptEntropy(entropySource, System.currentTimeMillis(), 0);
        this.acceptEntropy(entropySource, Runtime.getRuntime().freeMemory(), 0);
        this.acceptEntropy(entropySource, Runtime.getRuntime().totalMemory(), 0);
        this.read_seed(string);
    }

    private void read_seed(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            EntropySource entropySource = new EntropySource();
            try {
                int n = 0;
                while (n < 32) {
                    this.acceptEntropy(entropySource, dataInputStream.readLong(), 64);
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fast_pool_reseed();
    }

    private void write_seed(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            int n = 0;
            while (n < 32) {
                dataOutputStream.writeLong(this.nextLong());
                ++n;
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generator_init(String string) {
        this.cipher_ctx = Util.getCipherByName(string);
        this.output_buffer = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.counter = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.allZeroString = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.tmp = new byte[this.cipher_ctx.getKeySize() / 8];
        this.fetch_counter = this.output_buffer.length;
    }

    private final void counterInc() {
        int n = this.counter.length - 1;
        while (n >= 0) {
            int n2 = n--;
            this.counter[n2] = (byte)(this.counter[n2] + 1);
            if (this.counter[n2] != 0) break;
        }
    }

    private final void generateOutput() {
        this.counterInc();
        this.output_buffer = this.cipher_ctx.encipher(this.counter);
        if (this.output_count++ > 10) {
            this.output_count = 0;
            this.nextBytes(this.tmp);
            this.rekey(this.tmp);
        }
    }

    private void rekey(byte[] byArray) {
        this.cipher_ctx.initialize(byArray);
        this.counter = this.cipher_ctx.encipher(this.allZeroString);
        Util.wipe(byArray);
    }

    private synchronized int getBytes(int n) {
        if (this.fetch_counter + n > this.output_buffer.length) {
            this.fetch_counter = 0;
            this.generateOutput();
            return this.getBytes(n);
        }
        int n2 = this.fetch_counter;
        this.fetch_counter += n;
        return n2;
    }

    protected int next(int n) {
        int[] nArray = bitTable[n];
        int n2 = this.getBytes(nArray[0]);
        int n3 = this.output_buffer[n2];
        if (nArray[0] == 4) {
            n3 += (this.output_buffer[n2 + 1] << 24) + (this.output_buffer[n2 + 2] << 16) + (this.output_buffer[n2 + 3] << 8);
        } else if (nArray[0] == 3) {
            n3 += (this.output_buffer[n2 + 1] << 16) + (this.output_buffer[n2 + 2] << 8);
        } else if (nArray[0] == 2) {
            n3 += this.output_buffer[n2 + 2] << 8;
        }
        return n3 & nArray[1];
    }

    private void accumulator_init(String string) {
        this.fast_pool = Util.getDigestByName(string);
        this.slow_pool = Util.getDigestByName(string);
        this.digestSize = this.fast_pool.digestSize();
        this.entropySeen = new Hashtable();
    }

    public int acceptEntropy(EntropySource entropySource, long l, int n) {
        return this.accept_entropy(l, entropySource, Math.min(32, Math.min(this.estimateEntropy(entropySource, l), n)));
    }

    private int accept_entropy(long l, EntropySource entropySource, int n) {
        block4: {
            block3: {
                this.fast_select = !this.fast_select;
                Digest digest = this.fast_select ? this.fast_pool : this.slow_pool;
                digest.update((byte)l);
                digest.update((byte)(l >> 8));
                digest.update((byte)(l >> 16));
                digest.update((byte)(l >> 24));
                digest.update((byte)(l >> 32));
                digest.update((byte)(l >> 40));
                digest.update((byte)(l >> 48));
                digest.update((byte)(l >> 56));
                if (!this.fast_select) break block3;
                this.fast_entropy += n;
                if (this.fast_entropy <= 100) break block4;
                this.fast_pool_reseed();
                break block4;
            }
            this.slow_entropy += n;
            if (entropySource != null) {
                Integer n2 = (Integer)this.entropySeen.get(entropySource);
                n2 = n2 == null ? new Integer(n) : new Integer(n + n2);
                this.entropySeen.put(entropySource, n2);
                if (this.slow_entropy >= 320) {
                    int n3 = 0;
                    Enumeration enumeration = this.entropySeen.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        Integer n4 = (Integer)this.entropySeen.get(k);
                        if (n4 <= 160 || ++n3 < 2) continue;
                        this.slow_pool_reseed();
                        break;
                    }
                }
            }
        }
        return n;
    }

    private int estimateEntropy(EntropySource entropySource, long l) {
        int n = (int)(l - entropySource.lastVal);
        int n2 = n - entropySource.lastDelta;
        entropySource.lastDelta = n;
        int n3 = n2 - entropySource.lastDelta2;
        entropySource.lastDelta2 = n2;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n > n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        n >>= 1;
        n &= 0xFFF;
        n |= n >> 8;
        n |= n >> 4;
        n |= n >> 2;
        n |= n >> 1;
        n >>= 1;
        n -= n >> 1 & 0x555;
        n = (n & 0x333) + (n >> 2 & 0x333);
        n += n >> 4;
        n += n >> 8;
        entropySource.lastVal = l;
        return n & 0xF;
    }

    public int acceptTimerEntropy(EntropySource entropySource) {
        long l = System.currentTimeMillis();
        return this.acceptEntropy(entropySource, l - entropySource.lastVal, 32);
    }

    public void waitForEntropy(int n) {
    }

    private void reseed_init(String string) {
        this.reseed_ctx = Util.getDigestByName(string);
    }

    private void fast_pool_reseed() {
        byte[] byArray;
        byte[] byArray2 = byArray = this.fast_pool.digest();
        byte by = 0;
        while (by < 5) {
            this.reseed_ctx.update(byArray2, 0, byArray2.length);
            this.reseed_ctx.update(byArray, 0, byArray.length);
            this.reseed_ctx.update(by);
            byArray2 = this.reseed_ctx.digest();
            by = (byte)(by + 1);
        }
        Util.makeKey(byArray2, this.tmp, 0, this.tmp.length);
        this.rekey(this.tmp);
        Util.wipe(byArray);
        this.fast_entropy = 0;
        this.write_seed(this.seedfile);
    }

    private void slow_pool_reseed() {
        byte[] byArray = this.slow_pool.digest();
        this.fast_pool.update(byArray, 0, byArray.length);
        this.fast_pool_reseed();
        this.slow_entropy = 0;
        Integer n = new Integer(0);
        Enumeration enumeration = this.entropySeen.keys();
        while (enumeration.hasMoreElements()) {
            this.entropySeen.put(enumeration.nextElement(), n);
        }
    }

    public void close() {
    }

    public static void main(String[] stringArray) throws Exception {
        block23: {
            Yarrow yarrow;
            block27: {
                block26: {
                    byte[] byArray;
                    block25: {
                        block24: {
                            block22: {
                                yarrow = new Yarrow("/dev/urandom", "SHA1", "Rijndael");
                                byArray = new byte[1024];
                                if (stringArray.length != 0 && !stringArray[0].equalsIgnoreCase("latency")) break block22;
                                if (stringArray.length == 2) {
                                    byArray = new byte[Integer.parseInt(stringArray[1])];
                                }
                                long l = System.currentTimeMillis();
                                int n = 0;
                                while (n < 100) {
                                    yarrow.nextBytes(byArray);
                                    ++n;
                                }
                                System.out.println((double)(System.currentTimeMillis() - l) / (double)(100 * byArray.length) * 1024.0 + " ms/k");
                                l = System.currentTimeMillis();
                                int n2 = 0;
                                while (n2 < 1000) {
                                    yarrow.nextInt();
                                    ++n2;
                                }
                                System.out.println((double)(System.currentTimeMillis() - l) / 1000.0 + " ms/int");
                                l = System.currentTimeMillis();
                                int n3 = 0;
                                while (n3 < 1000) {
                                    yarrow.nextLong();
                                    ++n3;
                                }
                                System.out.println((double)(System.currentTimeMillis() - l) / 1000.0 + " ms/long");
                                break block23;
                            }
                            if (!stringArray[0].equalsIgnoreCase("randomness")) break block24;
                            int n = Integer.parseInt(stringArray[1]);
                            int n4 = 0;
                            while (n4 < n) {
                                yarrow.nextBytes(byArray);
                                ((FilterOutputStream)System.out).write(byArray);
                                ++n4;
                            }
                            break block23;
                        }
                        if (!stringArray[0].equalsIgnoreCase("gathering")) break block25;
                        System.gc();
                        EntropySource entropySource = new EntropySource();
                        long l = System.currentTimeMillis();
                        int n = 0;
                        while (n < 100000) {
                            yarrow.acceptEntropy(entropySource, System.currentTimeMillis(), 32);
                            ++n;
                        }
                        System.err.println((double)(System.currentTimeMillis() - l) / 100000.0);
                        System.gc();
                        l = System.currentTimeMillis();
                        int n5 = 0;
                        while (n5 < 100000) {
                            yarrow.acceptTimerEntropy(entropySource);
                            ++n5;
                        }
                        System.err.println((double)(System.currentTimeMillis() - l) / 100000.0);
                        break block23;
                    }
                    if (!stringArray[0].equalsIgnoreCase("volume")) break block26;
                    byArray = new byte[1020];
                    long l = System.currentTimeMillis() + (long)Integer.parseInt(stringArray[1]);
                    while (System.currentTimeMillis() < l) {
                        yarrow.nextBytes(byArray);
                        ((FilterOutputStream)System.out).write(byArray);
                    }
                    break block23;
                }
                if (stringArray[0].equals("stream")) {
                    RandFile randFile = new RandFile(stringArray[1]);
                    EntropySource entropySource = new EntropySource();
                    byte[] byArray = new byte[131072];
                    while (true) {
                        yarrow.acceptEntropy(entropySource, randFile.nextLong(), 32);
                        yarrow.nextBytes(byArray);
                        ((FilterOutputStream)System.out).write(byArray);
                    }
                }
                if (stringArray[0].equalsIgnoreCase("bitstream")) {
                    block8: while (true) {
                        int n = yarrow.nextInt();
                        int n6 = 0;
                        while (true) {
                            if (n6 >= 32) continue block8;
                            if ((n >> n6 & 1) == 1) {
                                System.out.print('1');
                            } else {
                                System.out.print('0');
                            }
                            ++n6;
                        }
                        break;
                    }
                }
                if (!stringArray[0].equalsIgnoreCase("sample")) break block23;
                if (stringArray.length != 1 && !stringArray[1].equals("general")) break block27;
                System.out.println("nextInt(): ");
                int n = 0;
                while (n < 3) {
                    System.out.println(yarrow.nextInt());
                    ++n;
                }
                System.out.println("nextLong(): ");
                int n7 = 0;
                while (n7 < 3) {
                    System.out.println(yarrow.nextLong());
                    ++n7;
                }
                System.out.println("nextFloat(): ");
                int n8 = 0;
                while (n8 < 3) {
                    System.out.println(yarrow.nextFloat());
                    ++n8;
                }
                System.out.println("nextDouble(): ");
                int n9 = 0;
                while (n9 < 3) {
                    System.out.println(yarrow.nextDouble());
                    ++n9;
                }
                System.out.println("nextFullFloat(): ");
                int n10 = 0;
                while (n10 < 3) {
                    System.out.println(yarrow.nextFullFloat());
                    ++n10;
                }
                System.out.println("nextFullDouble(): ");
                int n11 = 0;
                while (n11 < 3) {
                    System.out.println(yarrow.nextFullDouble());
                    ++n11;
                }
                break block23;
            }
            if (!stringArray[1].equals("normalized")) break block23;
            int n = 0;
            while (n < 20) {
                System.out.println(yarrow.nextDouble());
                ++n;
            }
        }
    }

    private void consumeString(String string) {
        byte[] byArray = string.getBytes();
        this.consumeBytes(byArray);
    }

    private void consumeBytes(byte[] byArray) {
        if (this.fast_select) {
            this.fast_pool.update(byArray, 0, byArray.length);
        } else {
            this.slow_pool.update(byArray, 0, byArray.length);
        }
        this.fast_select = !this.fast_select;
    }
}

