/*
 * Decompiled with CFR 0.152.
 */
package Freenet.crypt.ciphers;

import Freenet.Core;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.ciphers.Rijndael_Algorithm;
import Freenet.support.Fields;
import Freenet.support.Logger;
import java.security.InvalidKeyException;

public class Rijndael
implements BlockCipher {
    private Object sessionKey;
    private int keysize;
    private int blocksize;

    public Rijndael(int n) {
        this(n, 128);
    }

    public Rijndael(int n, int n2) {
        if (n != 128 && n != 192 && n != 256) {
            throw new RuntimeException("Invalid keysize");
        }
        if (n2 != 128 && n2 != 192 && n2 != 256) {
            throw new RuntimeException("Invalid blocksize");
        }
        this.keysize = n;
        this.blocksize = n2;
    }

    public Rijndael() {
        this(128, 128);
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public int getKeySize() {
        return this.keysize;
    }

    public void initialize(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[this.keysize >> 3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            Core.logger.log(this, "Invalid key", Logger.ERROR);
        }
    }

    public byte[] encipher(byte[] byArray) {
        return Rijndael_Algorithm.blockEncrypt(byArray, 0, this.sessionKey);
    }

    public byte[] decipher(byte[] byArray) {
        return Rijndael_Algorithm.blockDecrypt(byArray, 0, this.sessionKey);
    }

    public static void main(String[] stringArray) {
        System.out.println("KEYSIZE=128\n");
        Rijndael.monteCarlo(128);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=192\n");
        Rijndael.monteCarlo(192);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=256\n");
        Rijndael.monteCarlo(256);
    }

    static void monteCarlo(int n) {
        Rijndael rijndael = new Rijndael(n);
        int n2 = n / 8;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        while (n3 < 400) {
            System.out.println("I=" + n3);
            System.out.println("KEY=" + Fields.bytesToHex(byArray4, 0, n2));
            System.out.println("PT=" + Fields.bytesToHex(byArray, 0, 16));
            rijndael.initialize(byArray4);
            int n4 = 0;
            while (n4 < 10000) {
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                byArray2 = rijndael.encipher(byArray);
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                ++n4;
            }
            System.out.println("CT=" + Fields.bytesToHex(byArray2, 0, 16));
            int n5 = 0;
            while (n5 < n2) {
                if (n == 192) {
                    if (n5 < 8) {
                        int n6 = n5;
                        byArray4[n6] = (byte)(byArray4[n6] ^ byArray3[8 + n5]);
                    } else {
                        int n7 = n5;
                        byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5 - 8]);
                    }
                } else if (n == 256) {
                    if (n5 < 16) {
                        int n8 = n5;
                        byArray4[n8] = (byte)(byArray4[n8] ^ byArray3[n5]);
                    } else {
                        int n9 = n5;
                        byArray4[n9] = (byte)(byArray4[n9] ^ byArray2[n5 - 16]);
                    }
                } else {
                    int n10 = n5;
                    byArray4[n10] = (byte)(byArray4[n10] ^ byArray2[n5]);
                }
                ++n5;
            }
            if (n == 192) {
                int n11 = 0;
                while (n11 < 8) {
                    int n12 = n11 + 16;
                    byArray4[n12] = (byte)(byArray4[n12] ^ byArray3[n11 + 8]);
                    ++n11;
                }
            } else if (n == 256) {
                int n13 = 0;
                while (n13 < 16) {
                    int n14 = n13 + 16;
                    byArray4[n14] = (byte)(byArray4[n14] ^ byArray3[n13]);
                    ++n13;
                }
            }
            System.out.println();
            ++n3;
        }
    }
}

