/*
 * Decompiled with CFR 0.152.
 */
package Freenet.keys;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.crypt.ProgressiveHashInputStream;
import Freenet.crypt.SHA1;
import Freenet.support.Fields;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.InputStream;

public class CHK
extends Key {
    public static int keyNumber = 769;

    public CHK(byte[] byArray) throws KeyException {
        super(byArray);
        if (this.val.length != 23 || (this.val[21] & 0xFF) != (keyNumber >> 8 & 0xFF) || (this.val[22] & 0xFF) != (keyNumber & 0xFF)) {
            throw new KeyException("Byte array does not contain a CHK");
        }
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, FieldSet fieldSet, long l) throws DataNotValidIOException {
        try {
            String string = fieldSet == null ? null : fieldSet.get("PartSize");
            SHA1 sHA1 = new SHA1();
            long l2 = string == null ? 0L : Fields.stringToLong(string);
            long l3 = 1 << (this.val[20] & 0x3F);
            if (l2 != 0L ? l3 != 1L && (l2 -= (long)(sHA1.digestSize() >> 3)) > l3 : l3 != 1L && l > l3) {
                throw new DataNotValidIOException(131);
            }
            return new ProgressiveHashInputStream(inputStream, l2, l, new SHA1(), this.val);
        }
        catch (DataNotValidIOException dataNotValidIOException) {
            throw dataNotValidIOException;
        }
        catch (Exception exception) {
            exception.printStackTrace(Core.logger.getOut());
            throw new DataNotValidIOException(131);
        }
    }

    public boolean isCachable() {
        return true;
    }

    public String toString() {
        return Fields.bytesToHex(this.val, 0, 23);
    }
}

