/*
 * Decompiled with CFR 0.152.
 */
package Freenet.keys;

import Freenet.FieldSet;
import Freenet.KeyException;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.Global;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.keys.SVK;
import Freenet.support.Fields;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.InputStream;
import java.util.Random;

public class KSK
extends SVK {
    public static int keyNumber = 514;

    public static void main(String[] stringArray) {
        FieldSet fieldSet = new FieldSet();
        KSK kSK = KSK.makeKSK("hello", fieldSet);
        System.out.println("KSK for \"hello\" : " + kSK);
        System.out.println("Public key : " + fieldSet.get("Public-key"));
        KSK kSK2 = KSK.makeKSK("Freenet", fieldSet);
        System.out.println("KSK for \"Freenet\" : " + kSK2);
        System.out.println("Public key : " + fieldSet.get("Public-key"));
    }

    public static KSK makeKSK(String string, FieldSet fieldSet) {
        byte[] byArray = Util.hashString(new SHA1(), string);
        DSAKeyPair dSAKeyPair = new DSAKeyPair(Util.byteArrayToMPI(byArray), Global.DSAgroupA);
        byte[] byArray2 = SVK.makeSVK(dSAKeyPair, null, fieldSet, keyNumber);
        return new KSK(byArray2, dSAKeyPair);
    }

    public KSK(byte[] byArray) throws KeyException {
        this(byArray, null);
    }

    public KSK(byte[] byArray, DSAKeyPair dSAKeyPair) throws KeyException {
        super(byArray, keyNumber, dSAKeyPair);
    }

    public boolean isCachable() {
        return true;
    }

    public void sign(byte[] byArray, Random random, FieldSet fieldSet) {
        super.sign(byArray, random, fieldSet);
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, FieldSet fieldSet, long l) throws DataNotValidIOException {
        return super.verifyStream(inputStream, fieldSet, l, keyNumber);
    }

    public String toString() {
        return Fields.bytesToHex(this.val, 0, 23);
    }
}

