/*
 * Decompiled with CFR 0.152.
 */
package Freenet.keys;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.crypt.DSA;
import Freenet.crypt.DSAGroup;
import Freenet.crypt.DSAKeyPair;
import Freenet.crypt.DSASignature;
import Freenet.crypt.DSSVerifyingInputStream;
import Freenet.crypt.Global;
import Freenet.crypt.SHA1;
import Freenet.crypt.Util;
import Freenet.crypt.Yarrow;
import Freenet.support.Fields;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Random;

public class SVK
extends Key {
    public static final int SVK_MAXSIZE = 32768;
    private DSAKeyPair kp;
    public static int keyNumber = 513;

    public static void main(String[] stringArray) {
        SVK sVK = SVK.makeSVK(new Yarrow(), null, null);
        System.out.println("Random SVK : " + sVK);
    }

    public static SVK makeSVK(Random random, String string, FieldSet fieldSet) {
        BigInteger bigInteger = Util.generateLargeRandom(128, 256, random);
        DSAKeyPair dSAKeyPair = new DSAKeyPair(bigInteger, Global.DSAgroupB);
        return SVK.makeSVK(dSAKeyPair, string, fieldSet);
    }

    public static SVK makeSVK(DSAKeyPair dSAKeyPair, String string, FieldSet fieldSet) {
        byte[] byArray = SVK.makeSVK(dSAKeyPair, string, fieldSet, keyNumber);
        SVK sVK = new SVK(byArray, keyNumber, dSAKeyPair);
        return sVK;
    }

    public static SVK makeSVK(byte[] byArray, String string) {
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray, 0, byArray.length - 3);
        byte[] byArray2 = Util.hashString(new SHA1(), string);
        sHA1.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = sHA1.digest();
        byte[] byArray4 = new byte[23];
        System.arraycopy(byArray3, 0, byArray4, 0, 20);
        byArray4[20] = Key.lengthLimit(32768L);
        byArray4[21] = (byte)(keyNumber >> 8 & 0xFF);
        byArray4[22] = (byte)(keyNumber & 0xFF);
        return new SVK(byArray4);
    }

    protected static byte[] makeSVK(DSAKeyPair dSAKeyPair, String string, FieldSet fieldSet, int n) {
        byte[] byArray;
        byte[] byArray2 = Util.MPIbytes(dSAKeyPair.getY());
        byte[] byArray3 = null;
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray2, 0, byArray2.length);
        if (string != null) {
            byArray = sHA1.digest();
            sHA1.update(byArray, 0, byArray.length);
            byArray3 = Util.hashString(new SHA1(), string);
            if (fieldSet != null) {
                fieldSet.add("Document-name", Fields.bytesToHex(byArray3, 0, byArray3.length));
            }
            sHA1.update(byArray3, 0, byArray3.length);
        }
        byArray = sHA1.digest();
        byte[] byArray4 = new byte[23];
        System.arraycopy(byArray, 0, byArray4, 0, 20);
        byArray2 = dSAKeyPair.getY().toByteArray();
        if (fieldSet != null) {
            fieldSet.add("Public-key", Fields.bytesToHex(byArray2, 0, byArray2.length));
        }
        byArray4[20] = Key.lengthLimit(32768L);
        byArray4[21] = (byte)(n >> 8 & 0xFF);
        byArray4[22] = (byte)(n & 0xFF);
        return byArray4;
    }

    public SVK(byte[] byArray) throws KeyException {
        this(byArray, keyNumber, null);
    }

    protected SVK(byte[] byArray, int n) {
        this(byArray, n, null);
    }

    protected SVK(byte[] byArray, int n, DSAKeyPair dSAKeyPair) {
        super(byArray);
        if (this.val.length != 23 || this.val[21] != (n >> 8 & 0xFF) || this.val[22] != (n & 0xFF)) {
            throw new KeyException("byte array did not contain an SVK or KSK");
        }
        this.kp = dSAKeyPair;
    }

    public DSAKeyPair getKeyPair() {
        return this.kp;
    }

    public void sign(byte[] byArray, Random random, FieldSet fieldSet) {
        BigInteger bigInteger = Util.generateLargeRandom(80, 160, random);
        BigInteger bigInteger2 = Util.byteArrayToMPI(byArray);
        DSASignature dSASignature = DSA.sign(this.kp, bigInteger, bigInteger2);
        fieldSet.add("Signature", dSASignature.toString());
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, FieldSet fieldSet, long l) throws DataNotValidIOException {
        return this.verifyStream(inputStream, fieldSet, l, keyNumber);
    }

    protected VerifyingInputStream verifyStream(InputStream inputStream, FieldSet fieldSet, long l, int n) throws DataNotValidIOException {
        try {
            byte[] byArray;
            if (this.val[20] != 0 && l > (long)(1 << (this.val[20] & 0x3F))) {
                System.err.println(l + " > " + (1 >> (this.val[20] & 0x3F)));
                throw new DataNotValidIOException(131);
            }
            DSAKeyPair dSAKeyPair = null;
            DSASignature dSASignature = null;
            SHA1 sHA1 = new SHA1();
            String string = null;
            String string2 = null;
            if ((n & 0xFF) == 1) {
                string2 = fieldSet.get("Group");
                string = fieldSet.get("Document-name");
            }
            try {
                dSAKeyPair = new DSAKeyPair(string2 == null ? ((n & 0xFF) == 1 ? Global.DSAgroupB : Global.DSAgroupA) : DSAGroup.parse(string2), Util.byteArrayToMPI(Util.hexToBytes(fieldSet.get("Public-key"))));
                dSASignature = new DSASignature(fieldSet.get("Signature"));
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new DataNotValidIOException(131);
            }
            byte[] byArray2 = new byte[23];
            byArray2[20] = this.val[20];
            byArray2[21] = (byte)(n >> 8);
            byArray2[22] = (byte)n;
            SHA1 sHA12 = new SHA1();
            byte[] byArray3 = Util.MPIbytes(dSAKeyPair.getY());
            sHA12.update(byArray3, 0, byArray3.length);
            if (string != null) {
                byArray = sHA12.digest();
                sHA12.update(byArray, 0, byArray.length);
                byte[] byArray4 = Util.hexToBytes(string);
                sHA12.update(byArray4, 0, byArray4.length);
                sHA1.update(byArray4, 0, byArray4.length);
            }
            byArray = sHA12.digest();
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            if (!Util.byteArrayEqual(byArray2, this.val)) {
                throw new DataNotValidIOException(131);
            }
            return new DSSVerifyingInputStream(inputStream, dSAKeyPair, dSASignature, l, sHA1);
        }
        catch (DataNotValidIOException dataNotValidIOException) {
            throw dataNotValidIOException;
        }
        catch (Exception exception) {
            exception.printStackTrace(Core.logger.getOut());
            throw new DataNotValidIOException(0);
        }
    }

    public boolean isCachable() {
        return true;
    }

    public String toString() {
        return Fields.bytesToHex(this.val, 0, 23);
    }
}

