/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.BadAddressException;
import Freenet.ConduitException;
import Freenet.ConnectFailedException;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.DataSend;
import Freenet.message.KeyedMM;
import Freenet.message.SendDone;
import Freenet.node.Node;
import Freenet.support.Logger;
import Freenet.support.io.DataNotValidIOException;
import java.io.InputStream;

public class DataInsert
extends DataSend {
    public static final String messageName = "DataInsert";

    public DataInsert(long l, long l2, long l3, FieldSet fieldSet) throws BadAddressException {
        super(l, l2, l3, fieldSet);
    }

    public DataInsert(long l, long l2, long l3, FieldSet fieldSet, InputStream inputStream) throws BadAddressException {
        super(l, l2, l3, fieldSet);
        this.in = inputStream;
    }

    public DataInsert(RawMessage rawMessage) throws InvalidMessageException, BadAddressException {
        super(rawMessage);
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    public SendDone getSendDone(InputStream inputStream) {
        return new InsertSendDone(inputStream);
    }

    private class InsertSendDone
    extends SendDone {
        public InsertSendDone(InputStream inputStream) {
            super(DataInsert.this.id, inputStream);
        }

        protected MessageMemory sendFinished(Node node, KeyedMM keyedMM) {
            try {
                keyedMM.storeData.resetDataSource(true);
                if (keyedMM.dataCon == null || !keyedMM.dataCon.isOpen()) {
                    keyedMM.dataCon = node.makeConnection(keyedMM.dataref);
                }
                keyedMM.storeData.sending(node, keyedMM.dataCon);
                keyedMM.dataCon.unlockedSend(keyedMM.storeData, null);
            }
            catch (ConnectFailedException connectFailedException) {
                Core.logger.log(this, "Failed to connect to next node (" + connectFailedException.peer + ") to send StoreData message", Logger.MINOR);
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Send of StoreData message following finished trailing field failed.", Logger.MINOR);
            }
            keyedMM.state = 60;
            return keyedMM;
        }

        protected MessageMemory sendFailed(Node node, KeyedMM keyedMM, ConduitException conduitException) {
            keyedMM.state = 10;
            if (conduitException.inRead()) {
                if (conduitException.getIOException() instanceof DataNotValidIOException) {
                    int n = ((DataNotValidIOException)conduitException.getIOException()).getCode();
                    Core.logger.log(this, "Insert died on control byte: " + n, Logger.MINOR);
                } else {
                    Core.logger.log(this, "Error reading from local cache!", Logger.ERROR);
                }
            } else {
                Core.logger.log(this, "Ouput error sending trailing field", Logger.MINOR);
            }
            return keyedMM;
        }
    }
}

