/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.BadAddressException;
import Freenet.ConduitException;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.DataSend;
import Freenet.message.KeyedMM;
import Freenet.message.RequestRestarted;
import Freenet.message.SendDone;
import Freenet.message.TimedOut;
import Freenet.node.BadDataException;
import Freenet.node.Entity;
import Freenet.node.Node;
import Freenet.support.Logger;
import Freenet.support.io.DataNotValidIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;

public class DataReply
extends DataSend {
    public static final String messageName = "DataReply";

    public DataReply(long l, long l2, long l3, FieldSet fieldSet) throws UnknownHostException {
        super(l, l2, l3, fieldSet);
    }

    public DataReply(long l, long l2, long l3, Entity entity) throws IOException, BadDataException, BadAddressException {
        super(l, l2, l3, entity);
    }

    public DataReply(RawMessage rawMessage) throws InvalidMessageException, BadAddressException {
        super(rawMessage);
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        if (messageMemory == null || messageMemory.depth <= 0L) {
            return null;
        }
        TimedOut timedOut = new TimedOut(this.id, messageMemory.depth);
        try {
            timedOut.sendBack(node, messageMemory);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Send failed on timedout", Logger.NORMAL);
        }
        return super.timeOut(node, messageMemory);
    }

    protected SendDone getSendDone(InputStream inputStream) {
        return new ReplySendDone(inputStream);
    }

    private class ReplySendDone
    extends SendDone {
        public ReplySendDone(InputStream inputStream) {
            super(DataReply.this.id, inputStream);
        }

        protected MessageMemory sendFinished(Node node, KeyedMM keyedMM) {
            try {
                if (!(node.getTransience() || keyedMM.storeData.dataSource != null && DataReply.this.receivedAt != null && Core.randSource.nextInt() % 30 != 0)) {
                    keyedMM.storeData.resetDataSource(true);
                }
                ConnectionHandler connectionHandler = keyedMM.replyCon == null || !keyedMM.replyCon.isOpen() ? node.makeConnection(keyedMM.origRec) : keyedMM.replyCon;
                keyedMM.storeData.sending(node, connectionHandler);
                connectionHandler.unlockedSend(keyedMM.storeData, null);
            }
            catch (ConnectFailedException connectFailedException) {
                Core.logger.log(this, "Send of StoreData message to " + connectFailedException.peer + " following finished trailing field failed", Logger.MINOR);
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Send of StoreData message to " + sendFailedException.peer + " following finished trailing field failed", Logger.MINOR);
            }
            keyedMM.state = 60;
            return keyedMM;
        }

        protected MessageMemory sendFailed(Node node, KeyedMM keyedMM, ConduitException conduitException) {
            block11: {
                keyedMM.state = 10;
                if (conduitException.inRead()) {
                    if (conduitException.getIOException() instanceof DataNotValidIOException) {
                        int n = ((DataNotValidIOException)conduitException.getIOException()).getCode();
                        keyedMM.data = null;
                        try {
                            if (n == 129 || n == 130) {
                                conduitException.getOutStream().write(1);
                                if (keyedMM.rr != null) {
                                    node.timer.add(0L, keyedMM.rr);
                                }
                                break block11;
                            }
                            if (n == 1) {
                                conduitException.getOutStream().write(1);
                                if (keyedMM.rr != null) {
                                    node.timer.add(RequestRestarted.getTime(1L), keyedMM.rr);
                                }
                                if (keyedMM.queryRestarted != null) {
                                    keyedMM = (KeyedMM)keyedMM.queryRestarted.pReceived(node, keyedMM);
                                }
                                break block11;
                            }
                            Core.logger.log(this, "Choked on unknown Control byte: " + n, Logger.NORMAL);
                        }
                        catch (IOException iOException) {
                            Core.logger.log(this, "Error writing control byte", Logger.MINOR);
                        }
                    } else {
                        Core.logger.log(this, "Error reading from local cache!", Logger.ERROR);
                    }
                } else {
                    Core.logger.log(this, "Ouput error sending trailing field", Logger.MINOR);
                }
            }
            return keyedMM;
        }
    }
}

