/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.InvalidMessageException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.node.Node;

public class Echo
extends Message {
    public static final String messageName = "Echo";
    public Address[] visits;

    public Echo(long l, long l2, Address[] addressArray) {
        super(l, l2, 0L, null);
        this.visits = addressArray;
    }

    public Echo(RawMessage rawMessage) throws InvalidMessageException, BadAddressException {
        super(rawMessage);
        String string = this.otherFields.get("Hops");
        if (string == null) {
            throw new InvalidMessageException("Echo: No Hops field");
        }
        this.visits = new Address[new Integer(string).intValue()];
        int n = 0;
        while (n < this.visits.length) {
            String string2 = this.otherFields.get("hop" + n);
            if (string2 == null) {
                throw new InvalidMessageException("Echo: No hop" + n + " field");
            }
            this.visits[n] = new Address(string2);
            ++n;
        }
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        rawMessage.fs.add("Hops", String.valueOf(this.visits.length));
        int n = 0;
        while (n < this.visits.length) {
            rawMessage.fs.add("hop" + n, this.visits[n].toString());
            ++n;
        }
        return rawMessage;
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory == null) {
            if (this.visits.length == 0) {
                try {
                    node.sendMessage(this, this.source);
                }
                catch (SendFailedException sendFailedException) {
                    // empty catch block
                }
                return null;
            }
            Address address = this.source;
            Address address2 = this.visits[0];
            Address[] addressArray = new Address[this.visits.length - 1];
            int n = 0;
            while (n < addressArray.length) {
                addressArray[n] = this.visits[n + 1];
                ++n;
            }
            this.visits = addressArray;
            try {
                node.sendMessage(this, address2);
            }
            catch (SendFailedException sendFailedException) {
                // empty catch block
            }
            return new MessageMemory(address, this.depth);
        }
        try {
            node.sendMessage(this, messageMemory.origRec);
        }
        catch (SendFailedException sendFailedException) {
            // empty catch block
        }
        return null;
    }
}

