/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Core;
import Freenet.Handshake;
import Freenet.InvalidMessageException;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.node.Node;
import Freenet.support.Logger;

public class HandshakeReply
extends Handshake {
    public static final String messageName = "HandshakeReply";
    public String version;
    public String build;
    public String revision;

    public HandshakeReply(long l) {
        super(l);
        this.version = "1.299";
        this.build = "161";
        this.revision = Core.serverRevision;
    }

    public HandshakeReply(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
        this.version = this.otherFields.get("Version");
        this.otherFields.remove("Version");
        this.otherFields.remove("Build");
        this.otherFields.remove("Revision");
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        rawMessage.fs.add("Version", this.version);
        if (this.build != null) {
            rawMessage.fs.add("Build", this.build);
        }
        if (this.revision != null) {
            rawMessage.fs.add("Revision", this.revision);
        }
        rawMessage.trailingFieldName = "EndMessage";
        return rawMessage;
    }

    public boolean check() {
        return this.version.equals("1.299");
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        this.handle(node);
        return null;
    }

    public void handle(Core core) {
        if (this.check()) {
            Core.logger.log(this, "Setting handshake from " + this.source, Logger.DEBUGGING);
            core.hh.setHandshake(this.id);
        } else {
            Core.logger.log(this, "Bad handshake received", Logger.MINOR);
            core.hh.failHandshake(this.id);
        }
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        return this.pReceived(node, messageMemory);
    }
}

