/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.Handshake;
import Freenet.InvalidMessageException;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.HandshakeReply;
import Freenet.node.Node;
import Freenet.support.Logger;

public class HandshakeRequest
extends Handshake {
    public static final String messageName = "HandshakeRequest";
    private boolean keepalive;

    public HandshakeRequest(long l) {
        super(l);
    }

    public HandshakeRequest(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        this.handle(node);
        return null;
    }

    public void handle(Core core) {
        Core.logger.log(this, "Received handshake request", Logger.DEBUGGING);
        HandshakeReply handshakeReply = new HandshakeReply(this.id);
        try {
            ConnectionHandler connectionHandler;
            if (this.receivedWith == null) {
                connectionHandler = core.connect(this.source);
                handshakeReply.keepAlive = false;
            } else {
                connectionHandler = !this.receivedWith.isOpen() ? core.connect(this.source) : this.receivedWith;
            }
            handshakeReply.sending(core, connectionHandler);
            connectionHandler.sendMessage(handshakeReply);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Could not send handshake reply", Logger.MINOR);
        }
        catch (ConnectFailedException connectFailedException) {
            Core.logger.log(this, "Could not send handshake reply", Logger.MINOR);
        }
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        return this.pReceived(node, messageMemory);
    }
}

