/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.message.RequestRestarted;
import Freenet.node.Node;
import Freenet.support.Logger;

public class QueryRestarted
extends Message {
    public static final String messageName = "QueryRestarted";

    public QueryRestarted(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
    }

    public QueryRestarted(long l, long l2) {
        super(l, l2, 0L, null);
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        rawMessage.trailingFieldName = "EndMessage";
        return rawMessage;
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory == null) {
            return null;
        }
        if (messageMemory instanceof KeyedMM) {
            KeyedMM keyedMM = (KeyedMM)messageMemory;
            if (!keyedMM.lastAddr.equals(this.source)) {
                Core.logger.log(this, "Stale QueryRestarted from " + this.source + ", expected from " + keyedMM.lastAddr, Logger.DEBUGGING);
                return messageMemory;
            }
            if (keyedMM.state >= 30 && keyedMM.state < 40) {
                Core.logger.log(this, "QueryRestarted waiting for (bad) data to finish downloading.", Logger.DEBUGGING);
                keyedMM.queryRestarted = this;
                return keyedMM;
            }
            if (keyedMM.state != 10) {
                Core.logger.log(this, "Received QueryRestarted message for request that was not pending", Logger.MINOR);
                return keyedMM;
            }
            if (keyedMM.rr != null) {
                keyedMM.rr.cancel();
            }
            try {
                messageMemory.replyCon = this.sendBack(node, messageMemory);
                if (keyedMM.rr != null) {
                    node.timer.add(RequestRestarted.getTime(keyedMM.rr.hopsToLive()), keyedMM.rr);
                }
            }
            catch (SendFailedException sendFailedException) {
                Core.logger.log(this, "Send failed on return to " + sendFailedException.peer, Logger.NORMAL);
            }
        }
        return messageMemory;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        Core.logger.log(this, "Errant QueryRestarted message died", Logger.NORMAL);
        return null;
    }
}

