/*
 * Decompiled with CFR 0.152.
 */
package Freenet.message;

import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.Message;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.message.KeyedMM;
import Freenet.node.Node;
import Freenet.support.Logger;

public class TimedOut
extends Message {
    public static final String messageName = "TimedOut";

    public TimedOut(long l, long l2) {
        super(l, l2, 0L, null);
        this.keepAlive = false;
    }

    public TimedOut(RawMessage rawMessage) throws InvalidMessageException {
        super(rawMessage);
        this.keepAlive = false;
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = super.toRawMessage(presentation);
        rawMessage.messageType = messageName;
        return rawMessage;
    }

    public MessageMemory pReceived(Node node, MessageMemory messageMemory) {
        if (messageMemory == null || !(messageMemory instanceof KeyedMM)) {
            return null;
        }
        KeyedMM keyedMM = (KeyedMM)messageMemory;
        if (keyedMM.state != 10) {
            Core.logger.log(this, "Received TimedOut message for request that was not pending", Logger.MINOR);
            return keyedMM;
        }
        if (keyedMM.rr != null) {
            keyedMM.rr.cancel();
        }
        try {
            this.sendBack(node, messageMemory);
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Send failed on return to " + sendFailedException.peer, Logger.NORMAL);
        }
        keyedMM.state = 60;
        return null;
    }

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        Core.logger.log(this, "Errant TimedOut message died", Logger.NORMAL);
        return messageMemory;
    }
}

