/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.node.BadEntryException;
import Freenet.node.Entity;
import Freenet.node.NodeReference;
import Freenet.node.StandardDataStore;
import Freenet.support.Fields;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

class DataStoreItem
implements Serializable {
    public Key key;
    public NodeReference ref;
    public Entity doc;

    public DataStoreItem(Key key, NodeReference nodeReference, Entity entity) {
        this.key = key;
        this.ref = nodeReference;
        this.doc = entity;
    }

    public DataStoreItem(DataInputStream dataInputStream, StandardDataStore standardDataStore) throws IOException, BadEntryException {
        boolean bl = false;
        try {
            this.key = Key.readKey(dataInputStream.readUTF());
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            bl = true;
        }
        try {
            String string = dataInputStream.readUTF();
            if (!string.equals("")) {
                this.ref = new NodeReference(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            bl = true;
        }
        if (dataInputStream.readBoolean()) {
            this.doc = standardDataStore.newEntity(dataInputStream);
        }
        if (bl) {
            throw new BadEntryException();
        }
    }

    public DataStoreItem(FieldSet fieldSet, StandardDataStore standardDataStore) throws BadEntryException {
        try {
            String string;
            String string2 = fieldSet.get("Key");
            if (string2 == null) {
                throw new BadEntryException();
            }
            this.key = Key.readKey(string2);
            String string3 = fieldSet.get("Ref");
            if (string3 != null) {
                this.ref = new NodeReference(string3);
            }
            if ((string = fieldSet.get("HasEntity")) != null && Fields.stringToBool(string, false)) {
                this.doc = standardDataStore.newEntity(fieldSet);
            }
        }
        catch (KeyException keyException) {
            throw new BadEntryException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadEntryException();
        }
    }

    public long length() {
        return this.doc == null ? 0L : this.doc.length();
    }

    public FieldSet fields() {
        FieldSet fieldSet = new FieldSet();
        fieldSet.add("Key", this.key.toString());
        if (this.ref != null) {
            fieldSet.add("Ref", this.ref.toString());
        }
        if (this.doc != null) {
            fieldSet.add("HasEntity", Fields.boolToString(true));
            this.doc.write(fieldSet);
        }
        return fieldSet;
    }

    public String toString() {
        return "Key: " + this.key + ", Ref: " + this.ref + ", Doc: " + this.doc;
    }
}

