/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.node.BadDataException;
import Freenet.node.Data;
import Freenet.node.DataProperties;
import Freenet.support.Logger;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class Entity
implements Serializable {
    protected Data data;
    protected DataProperties props;

    protected Entity(Data data, DataProperties dataProperties) {
        this.data = data;
        this.props = dataProperties;
    }

    protected Entity() {
    }

    public Data data() {
        return this.data;
    }

    public DataProperties props() {
        return this.props;
    }

    public long length() {
        try {
            return (this.data == null ? 0L : this.data.getLength()) + (this.props == null ? 0L : this.props.length());
        }
        catch (BadDataException badDataException) {
            Core.logger.log(this, "Length read attempted on bad entity", Logger.ERROR);
            return this.props == null ? 0L : this.props.length();
        }
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract void write(FieldSet var1);

    public String toString() {
        return this.data.toString();
    }
}

