/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.FieldSet;
import Freenet.node.Entity;
import Freenet.node.FileData;
import Freenet.node.FileDataProperties;
import Freenet.support.io.SplitOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public abstract class FileEntity
extends Entity
implements Serializable {
    public FileData fileData() {
        return (FileData)this.data;
    }

    public FileDataProperties fileProps() {
        return (FileDataProperties)this.props;
    }

    protected FileEntity(SplitOutputStream splitOutputStream, long l, long l2) throws IOException {
        this.data = new FileData(splitOutputStream, l, l2);
        this.props = new FileDataProperties((FileData)this.data);
    }

    protected FileEntity(FieldSet fieldSet) {
        this(fieldSet.get("Data"), fieldSet.get("DataProperties"));
    }

    protected FileEntity(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUTF(), dataInputStream.readUTF());
    }

    private FileEntity(String string, String string2) {
        if (string != null && !string.equals("")) {
            this.data = new FileData(new File(string));
        }
        this.props = string2 != null && !string2.equals("") ? new FileDataProperties(new File(string2)) : new FileDataProperties((FileData)this.data);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        FileData fileData = (FileData)this.data;
        FileDataProperties fileDataProperties = (FileDataProperties)this.props;
        dataOutputStream.writeUTF(fileData == null ? "" : fileData.fileName());
        if (fileDataProperties == null) {
            dataOutputStream.writeUTF("");
        } else {
            dataOutputStream.writeUTF(fileDataProperties.isSaved() ? fileDataProperties.toString() : "");
        }
    }

    public void write(FieldSet fieldSet) {
        if (this.fileData() != null) {
            fieldSet.add("Data", this.fileData().fileName());
        }
        if (this.fileProps() != null && this.fileProps().isSaved()) {
            fieldSet.add("DataProperties", this.fileProps().toString());
        }
    }
}

