/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import java.util.Hashtable;

class LimitedHashtable
extends Hashtable {
    Container ptr = null;
    int size;
    int currentsize;

    public LimitedHashtable(int n) {
        this.size = n;
        this.currentsize = 0;
    }

    public synchronized Object[] limput(Object object, Object object2) {
        if (this.size == 0) {
            return null;
        }
        Container container = new Container(object, object2);
        Object[] objectArray = null;
        if (this.ptr == null) {
            container.prev = container;
            container.succ = container;
            this.ptr = container;
            ++this.currentsize;
        } else if (this.currentsize < this.size) {
            this.ptr.add(container);
            ++this.currentsize;
        } else {
            this.ptr.replace(container);
            super.remove(this.ptr.key);
            objectArray = new Object[]{this.ptr.key, this.ptr.o};
            this.ptr = container.succ;
        }
        super.put(object, container);
        return objectArray;
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.size == 0) {
            return null;
        }
        Container container = new Container(object, object2);
        if (this.ptr == null) {
            container.prev = container;
            container.succ = container;
            this.ptr = container;
            ++this.currentsize;
        } else if (this.currentsize < this.size) {
            this.ptr.add(container);
            ++this.currentsize;
        } else {
            this.ptr.replace(container);
            super.remove(this.ptr.key);
            this.ptr = container.succ;
        }
        Container container2 = super.put(object, container);
        return container2 == null ? null : container2.o;
    }

    public synchronized Object get(Object object) {
        Container container = (Container)super.get(object);
        return container == null ? null : container.o;
    }

    public synchronized Object remove(Object object) {
        Container container = (Container)super.remove(object);
        if (container != null) {
            if (this.currentsize > 1) {
                if (container == this.ptr) {
                    this.ptr = this.ptr.succ;
                }
                container.remove();
            } else {
                this.ptr = null;
            }
            --this.currentsize;
            return container.o;
        }
        return null;
    }

    public String toString() {
        return super.toString() + ", size: " + this.currentsize + ", max: " + this.size;
    }

    private class Container {
        public Object o;
        public Object key;
        public Container prev;
        public Container succ;

        public Container(Object object, Object object2) {
            this.o = object2;
            this.key = object;
        }

        public void add(Container container) {
            this.prev.succ = container;
            container.prev = this.prev;
            container.succ = this;
            this.prev = container;
        }

        public void replace(Container container) {
            this.prev.succ = container;
            this.succ.prev = container;
            container.succ = this.succ;
            container.prev = this.prev;
            this.prev = null;
            this.succ = null;
        }

        public void remove() {
            this.prev.succ = this.succ;
            this.succ.prev = this.prev;
            this.succ = null;
            this.prev = null;
        }

        public String toString() {
            if (this.o != null && this.key != null) {
                return this.key + " = " + this.o;
            }
            return null;
        }
    }
}

