/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.Core;
import Freenet.HandshakeHandler;
import Freenet.Key;
import Freenet.ListenException;
import Freenet.ListeningAddress;
import Freenet.MessageHandler;
import Freenet.Params;
import Freenet.Presentation;
import Freenet.StandardHandshakeHandler;
import Freenet.SuppressedHandshakeHandler;
import Freenet.crypt.SHA1;
import Freenet.keys.KHK;
import Freenet.node.DataStore;
import Freenet.node.DataStoreMaintence;
import Freenet.node.DelayInformWrite;
import Freenet.node.FileData;
import Freenet.node.FileDataProperties;
import Freenet.node.NodeReference;
import Freenet.node.ServiceLauncher;
import Freenet.node.StandardDataStore;
import Freenet.node.StandardMessageHandler;
import Freenet.node.StreamHandler;
import Freenet.presentation.FreenetProtocol;
import Freenet.support.Logger;
import Freenet.support.StandardLogger;
import Freenet.support.SuppressedLogger;
import Freenet.support.io.ThrottledOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Node
extends Core {
    public static Node n;
    public static boolean run;
    static final String BUILD = "LATEST_BUILD=";
    public static Params params;
    public static File dataPath;
    public static int maxHopsToLive;
    public static final String defaultDataPath = ".freenet";
    public static final String defaultDataPropertiesPath = ".freenet";
    public static final String defaultDataStorePath = ".freenet";
    public static final long defaultDiskCache = 100000000L;
    public static final int defaultDataStoreSize = 500;
    public static final int defaultMessageStoreSize = 500;
    public static final int defaultBandwidthLimit = 50000;
    public static final boolean defaultInformRead = true;
    public static final boolean defaultInformWrite = true;
    public static final long defaultInformDelay = 86400L;
    public static final String defaultInformUrl = "http://www.octayne.com/inform.php";
    public static final String defaultNodeFile = "nodes.config";
    public static final int defaultMaxHopsToLive = 100;
    public static final int defaultListenPort = 0;
    public static final int defaultLogging;
    public static final String defaultLogFile = "freenet.log";
    public static final int defaultVerbosity = 4;
    public static final long defaultCheckpointInterval = 300L;
    public DataStore ds;
    public StreamHandler sh = new StreamHandler(this);
    public NodeReference myRef = null;

    public static void main(String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer("$Id: Node.java,v 1.66 2000/11/30 21:29:45 misterbad Exp $", " ");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        Core.serverRevision = stringTokenizer.nextToken();
        try {
            StandardLogger standardLogger = new StandardLogger(System.out, 4, defaultLogging);
            Core.setLogger(standardLogger);
            try {
                params = new Params(Params.defaultRCFiles, stringArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                params = new Params(stringArray);
            }
            if (params.getParam("help") != null) {
                Node.usage();
                return;
            }
            if (params.getParam("version") != null) {
                Node.version();
                return;
            }
            int n = params.getint("listenPort", 0);
            Node.initNode(params, "" + n);
            Node.startNode(params, n);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void initNode(Params params, String string) {
        Logger logger;
        String string2 = params.getParam("logging");
        int n = string2 == null ? defaultLogging : StandardLogger.priorityOf(string2);
        int n2 = params.getint("verbosity", 4);
        String string3 = params.getParam("logFile", defaultLogFile);
        try {
            logger = !string3.equalsIgnoreCase("NO") ? new StandardLogger(string3, n2, n) : new StandardLogger(System.err, n2, n);
        }
        catch (IOException iOException) {
            System.err.println("Writing to log failed!");
            logger = new SuppressedLogger();
        }
        Core.setLogger(logger);
        Core.init(params);
        maxHopsToLive = params.getint("maxHopsToLive", 100);
        String string4 = params.getParam("dataPath", ".freenet") + File.separator + string;
        String string5 = params.getParam("dataPropertiesPath", ".freenet") + File.separator + string;
        FileData.path = new File(string4);
        if (!FileData.path.exists()) {
            FileData.path.mkdirs();
        }
        if (!(FileDataProperties.path = new File(string5)).exists()) {
            FileDataProperties.path.mkdirs();
        }
        int n3 = params.getint("bandwidthLimit", 50000);
        ThrottledOutputStream.setThrottle(n3);
    }

    public static void startNode(Params params, int n) {
        try {
            block17: {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string = Node.params.getParam("nodeAddress");
                    NodeReference nodeReference = null;
                    if (string != null) {
                        nodeReference = new NodeReference("tcp", string + ":" + n);
                    }
                    HandshakeHandler handshakeHandler = Node.params.getboolean("doHandshake", true) ? new StandardHandshakeHandler() : new SuppressedHandshakeHandler();
                    FreenetProtocol freenetProtocol = new FreenetProtocol();
                    String string2 = Node.params.getParam("dataStorePath", ".freenet");
                    StandardDataStore.filename = string2 + File.separator + "store_" + n;
                    StandardDataStore.dsminz = Node.params.getlong("dsminsz", 0L);
                    StandardDataStore.checkpointInterval = Node.params.getlong("checkpointInterval", 300L);
                    StandardDataStore standardDataStore = StandardDataStore.makeDataStore(Node.params.getlong("diskCache", 100000000L), Node.params.getint("dataStoreSize", 500));
                    try {
                        Node.n = new Node(standardDataStore, new ListeningAddress("tcp/" + n), freenetProtocol, handshakeHandler, nodeReference);
                    }
                    catch (ListenException listenException) {
                        System.out.println("Could not bind to port " + n + " - maybe another node is running?");
                        if (n < 1024) {
                            System.out.println("Or, you might not have privileges to bind to a port < 1024.");
                        }
                        System.exit(1);
                        Object var16_11 = null;
                        Core.randSource.close();
                        return;
                    }
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                    String string3 = Node.params.getParam("informUrl", defaultInformUrl);
                    if (string3 != null && Node.params.getboolean("informRead", true) || Node.params.getboolean("informWrite", true)) {
                        Node.inform(hashtable, string3);
                        if (Node.params.getlong("informDelay", 86400L) != 0L && Node.params.getboolean("informWrite", true)) {
                            object5 = new DelayInformWrite(Core.randSource.nextLong());
                            ((DelayInformWrite)object5).schedule(Node.n, Node.params.getlong("informDelay", 86400L));
                        }
                    }
                    try {
                        object5 = Node.params.getParam("nodeFile", defaultNodeFile);
                        object4 = new BufferedReader(new FileReader((String)object5));
                        object3 = new SHA1(true);
                        while (((BufferedReader)object4).ready()) {
                            object2 = ((BufferedReader)object4).readLine();
                            if (((String)(object2 = ((String)object2).trim())).equals("") || Node.n.ds.searchRef((Key)(object = KHK.makeKHK((String)object2))) != null) continue;
                            hashtable.put(object2, object);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    object5 = hashtable.keys();
                    while (object5.hasMoreElements()) {
                        object4 = (String)object5.nextElement();
                        try {
                            Node.n.ds.put((Key)hashtable.get(object4), new NodeReference((String)object4), null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Core.logger.log(null, "Bad node reference read from datastore initialization file.", Logger.MINOR);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (!run) break block17;
                    int n2 = Node.params.getint("messageStoreSize", 500);
                    object = new StandardMessageHandler(Node.n, n2);
                    object3 = new DataStoreMaintence(Core.randSource.nextLong());
                    ((DataStoreMaintence)object3).cleardir(standardDataStore);
                    ((DataStoreMaintence)object3).schedule(Node.n);
                    object2 = new ServiceLauncher(Node.params.getset("services"));
                    ((ServiceLauncher)object2).launch();
                    Node.n.acceptConnections((MessageHandler)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var16_13 = null;
                    Core.randSource.close();
                }
            }
            Object var16_12 = null;
            Core.randSource.close();
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            Core.randSource.close();
            throw throwable;
        }
    }

    private static final void informWrite(HttpURLConnection httpURLConnection) throws IOException {
        if (params.getboolean("informWrite", true) && params.getlong("informDelay", 86400L) == 0L) {
            httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
            String string = params.getParam("nodeAddress");
            if (string == null) {
                printWriter.print("port=" + params.getParam("listenPort"));
            } else {
                printWriter.print("write=tcp/" + string + ":" + params.getParam("listenPort"));
            }
            printWriter.close();
        }
    }

    private static final void informRead(HttpURLConnection httpURLConnection, Hashtable hashtable) throws IOException {
        if (params.getboolean("informRead", true)) {
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            SHA1 sHA1 = new SHA1(true);
            while (bufferedReader.ready()) {
                Object object;
                String string = bufferedReader.readLine();
                if ((string = string.trim()).startsWith(BUILD)) {
                    object = string.substring(BUILD.length());
                    if ("161".compareTo((String)object) >= 0) continue;
                    System.err.println("Newer build " + (String)object + " is available than this build " + "161" + ", please upgrade!");
                    continue;
                }
                if (string.equals("") || Node.n.ds.searchRef((Key)(object = KHK.makeKHK(string))) != null) continue;
                hashtable.put(string, object);
            }
            inputStreamReader.close();
        } else {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            byte[] byArray = new byte[1024];
            while (bufferedInputStream.read(byArray) != -1) {
            }
        }
    }

    private static final void inform(Hashtable hashtable, String string) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(true);
            Node.informWrite(httpURLConnection);
            Node.informRead(httpURLConnection, hashtable);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            Core.logger.log(null, "Inform Connection failed:" + exception, Logger.ERROR);
        }
    }

    public static void version() {
        System.out.println("Freenet server version 0.3 using protocol 1.299 (build 161 revision " + Core.serverRevision + ")");
    }

    public static void usage() {
        Node.version();
        System.out.println("Usage: freenet_server [options]");
        System.out.println("");
        System.out.println("  -connectTimeout msec       Time to wait for connection to remote node");
        System.out.println("  -dataStoreSize n           Max number of items to keep in store");
        System.out.println("  -diskCache bytes           Max size of disk cache");
        System.out.println("  -handshakeLife msec        Time to treat old handshakes as good");
        System.out.println("  -handshakeTimeout msec     Time to wait for handshake from remote node");
        System.out.println("  -informRead yes|no         Read initial nodes from list on webserver");
        System.out.println("  -informWrite yes|no        Add this node to list on webserver");
        System.out.println("  -informUrl url             URL of node list");
        System.out.println("  -listenPort port           Local port to listen on");
        System.out.println("  -logFile file              Name of log file (`no' to log to console)");
        System.out.println("  -logging error|normal|minor|debugging");
        System.out.println("                             Logging level");
        System.out.println("  -messageStoreSize n        Max number of pending messages to track");
        System.out.println("  -timePerHop msec           Time to wait for replies (per hop)");
        System.out.println("  -tunnel yes|no             Start forwarding messages while incomplete");
        System.out.println("  -verbosity 1-5             Verbosity of log messages");
        System.out.println("  -help                      Display this help and exit");
        System.out.println("  -version                   Output version information and exit");
        System.out.println("");
        System.out.println("Send bug reports to freenet-dev@lists.sourceforge.net");
    }

    public Node(DataStore dataStore, ListeningAddress listeningAddress, Presentation presentation, HandshakeHandler handshakeHandler) throws ListenException {
        this(dataStore, listeningAddress, presentation, handshakeHandler, null);
    }

    public Node(DataStore dataStore, ListeningAddress listeningAddress, Presentation presentation, HandshakeHandler handshakeHandler, NodeReference nodeReference) throws ListenException {
        super(listeningAddress, presentation, handshakeHandler);
        this.ds = dataStore;
        this.myRef = nodeReference;
    }

    static {
        run = true;
        defaultLogging = Logger.NORMAL;
    }
}

