/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.node.BadEntryException;
import Freenet.node.DataStore;
import Freenet.node.DataStoreItem;
import Freenet.node.Entity;
import Freenet.node.EntityEnumeration;
import Freenet.node.FileEntity;
import Freenet.node.NodeReference;
import Freenet.support.CyclicArray;
import Freenet.support.Logger;
import Freenet.support.io.ReadInputStream;
import Freenet.support.io.SplitOutputStream;
import Freenet.support.io.WriteOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class StandardDataStore
implements DataStore {
    private static long write_interval;
    public static String filename;
    public static long dsminz;
    public static long checkpointInterval;
    public long maxData;
    protected CyclicArray ar;
    protected Hashtable h;
    protected boolean needsWriting = false;

    public static StandardDataStore makeDataStore(long l, int n) {
        StandardDataStore standardDataStore = new StandardDataStore(l, n);
        if (!StandardDataStore.readV5DataStore(standardDataStore)) {
            Core.logger.log(null, "Couldn't load DataStore from " + filename, Logger.NORMAL);
        }
        return standardDataStore;
    }

    public static boolean readV5DataStore(StandardDataStore standardDataStore) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filename);
            ReadInputStream readInputStream = new ReadInputStream(new BufferedInputStream(fileInputStream));
            String string = "";
            try {
                string = readInputStream.readTo('\n', '\r');
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!string.equals("VERSION 5")) {
                Core.logger.log(null, "Not a verson 4 datastore", Logger.MINOR);
                return false;
            }
            try {
                boolean bl = true;
                while (bl) {
                    try {
                        FieldSet fieldSet = new FieldSet();
                        if (fieldSet.parseFields(readInputStream, '\n', '=', '.') != null) {
                            DataStoreItem dataStoreItem = new DataStoreItem(fieldSet, standardDataStore);
                            standardDataStore.put(dataStoreItem);
                            continue;
                        }
                        bl = false;
                    }
                    catch (BadEntryException badEntryException) {
                        Core.logger.log(null, "Bad entry while reading version 4 datastore file, skipping.", Logger.MINOR);
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                Core.logger.log(null, "Problem reading V4 datastore: " + iOException, Logger.NORMAL);
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        return true;
    }

    public boolean tofile() throws IOException {
        if (!this.needsWriting) {
            Core.logger.log(this, "No reason to write out datastore.", Logger.DEBUG);
            return false;
        }
        new DoWrite().doWrite(this, filename);
        return true;
    }

    protected StandardDataStore(long l, int n) {
        this.ar = new CyclicArray(n);
        this.h = new Hashtable();
        this.maxData = l;
    }

    public Enumeration keys() {
        return this.h.keys();
    }

    public Enumeration data() {
        return new EntityEnumeration(this);
    }

    public Entity searchData(Key key) {
        Core.logger.log(this, "searchData(" + key + ")", Logger.DEBUG);
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            DataStoreItem dataStoreItem = (DataStoreItem)this.h.get(key);
            if (dataStoreItem == null || dataStoreItem.doc == null) {
                Core.logger.log(this, "Not found.", Logger.DEBUG);
                Entity entity = null;
                return entity;
            }
            Core.logger.log(this, "Data found.", Logger.DEBUG);
            Entity entity = dataStoreItem.doc;
            NodeReference nodeReference = dataStoreItem.ref;
            this.remove(key);
            this.put(key, nodeReference, entity);
            Entity entity2 = entity;
            return entity2;
        }
    }

    public NodeReference searchRef(Key key) {
        if (key == null) {
            return null;
        }
        Core.logger.log(this, "called searchRef(" + key + ")", Logger.DEBUG);
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            DataStoreItem dataStoreItem = (DataStoreItem)this.h.get(key);
            if (dataStoreItem == null) {
                Core.logger.log(this, "Not found.", Logger.DEBUG);
                NodeReference nodeReference = null;
                return nodeReference;
            }
            Core.logger.log(this, "Ref found.", Logger.DEBUG);
            NodeReference nodeReference = dataStoreItem.ref;
            return nodeReference;
        }
    }

    public void remove(Key key) {
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            int n = 0;
            while (n < this.ar.length()) {
                DataStoreItem dataStoreItem = (DataStoreItem)this.ar.get(n);
                if (dataStoreItem != null && dataStoreItem.key.equals(key)) {
                    this.ar.remove(n);
                    this.h.remove(key);
                    this.needsWriting = true;
                    return;
                }
                ++n;
            }
        }
    }

    public void removeRef(Key key) {
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            DataStoreItem dataStoreItem = (DataStoreItem)this.h.get(key);
            if (dataStoreItem != null) {
                if (dataStoreItem.ref != null) {
                    Core.logger.log(this, "Removing ref to " + dataStoreItem.ref, Logger.DEBUG);
                }
                if (dataStoreItem.doc != null) {
                    Core.logger.log(this, "Removing ref", Logger.DEBUG);
                    dataStoreItem.ref = null;
                } else {
                    this.remove(key);
                }
            }
        }
    }

    public Key findClosestKey(Key key) {
        return this.findClosestKey(key, null);
    }

    public Key findClosestKey(Key key, Key key2) {
        boolean bl = false;
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            int n = this.findNextClosestPos(key, key2);
            if (n < 0) {
                Key key3 = null;
                return key3;
            }
            DataStoreItem dataStoreItem = (DataStoreItem)this.ar.get(n);
            if (dataStoreItem == null) {
                Key key4 = null;
                return key4;
            }
            Key key5 = dataStoreItem.key;
            return key5;
        }
    }

    public void put(Key key, NodeReference nodeReference, Entity entity) {
        if (entity != null) {
            // empty if block
        }
        this.put(new DataStoreItem(key, nodeReference, entity));
    }

    public synchronized void put(DataStoreItem dataStoreItem) {
        Key key = dataStoreItem.key;
        long l = 0L;
        int n = 0;
        while (n < this.ar.length() && l < dataStoreItem.length() && this.ar.get(n) != null) {
            long l2 = ((DataStoreItem)this.ar.get(n)).length();
            if (dsminz != 0L && l2 < dsminz) {
                l2 = dsminz;
            }
            l += l2;
            ++n;
        }
        if (n < this.ar.length()) {
            DataStoreItem dataStoreItem2 = this.ar.get(n) == null || ((DataStoreItem)this.ar.get((int)n)).doc == null ? (DataStoreItem)this.ar.insert(n, dataStoreItem) : (n != 0 ? (DataStoreItem)this.ar.insert(Math.abs(Core.randSource.nextInt()) % n, dataStoreItem) : (DataStoreItem)this.ar.insert(0, dataStoreItem));
            if (dataStoreItem2 != null) {
                this.h.remove(dataStoreItem2.key);
            }
            this.h.put(key, dataStoreItem);
            this.needsWriting = true;
            this.cleanUpData();
        }
    }

    public Entity newEntity(FieldSet fieldSet) {
        return new MyEntity(fieldSet);
    }

    public Entity newEntity(DataInputStream dataInputStream) throws IOException {
        return new MyEntity(dataInputStream);
    }

    public Entity newEntity(SplitOutputStream splitOutputStream, long l, long l2) throws IOException {
        return new MyEntity(splitOutputStream, l, l2);
    }

    protected int findNextClosestPos(Key key, Key key2) {
        StandardDataStore standardDataStore = this;
        synchronized (standardDataStore) {
            int n = -1;
            DataStoreItem dataStoreItem = null;
            int n2 = 0;
            while (n2 < this.ar.length()) {
                DataStoreItem dataStoreItem2 = (DataStoreItem)this.ar.get(n2);
                if (dataStoreItem2 != null && (dataStoreItem == null || key.compare(dataStoreItem2.key, dataStoreItem.key)) && (key2 == null || key.compare(key2, dataStoreItem2.key))) {
                    n = n2;
                    dataStoreItem = dataStoreItem2;
                }
                ++n2;
            }
            int n3 = n;
            return n3;
        }
    }

    protected void cleanUpData() {
        long l = 0L;
        int n = 0;
        while (n < this.ar.length()) {
            Object object = this.ar.get(n);
            if (object != null) {
                DataStoreItem dataStoreItem = (DataStoreItem)object;
                if (dataStoreItem.doc != null) {
                    if (l + dataStoreItem.doc.length() > this.maxData) {
                        dataStoreItem.doc = null;
                        this.needsWriting = true;
                    } else {
                        l += dataStoreItem.doc.length();
                    }
                }
            }
            ++n;
        }
    }

    public Hashtable refList() {
        Object object = new Object();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        while (n < this.ar.length()) {
            hashtable.put(((DataStoreItem)this.ar.get((int)n)).ref.toString(), object);
            ++n;
        }
        return hashtable;
    }

    public String toString() {
        return this.h.toString();
    }

    static {
        filename = ".freenet" + File.separator + "store";
        dsminz = 0L;
        checkpointInterval = 300L;
    }

    protected static class MyEntity
    extends FileEntity {
        public MyEntity(FieldSet fieldSet) {
            super(fieldSet);
        }

        public MyEntity(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        public MyEntity(SplitOutputStream splitOutputStream, long l, long l2) throws IOException {
            super(splitOutputStream, l, l2);
        }
    }

    protected static class DoWrite {
        protected DoWrite() {
        }

        public void doWrite(StandardDataStore standardDataStore, String string) throws IOException {
            Core.logger.log(this, "Writing datastore to disk", Logger.MINOR);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            WriteOutputStream writeOutputStream = new WriteOutputStream(bufferedOutputStream);
            writeOutputStream.writeUTF("VERSION 5", '\n');
            StandardDataStore standardDataStore2 = standardDataStore;
            synchronized (standardDataStore2) {
                CyclicArray cyclicArray = standardDataStore.ar;
                int n = cyclicArray.length() - 1;
                while (n >= 0) {
                    DataStoreItem dataStoreItem = (DataStoreItem)cyclicArray.get(n);
                    if (dataStoreItem != null) {
                        FieldSet fieldSet = dataStoreItem.fields();
                        fieldSet.writeFields(writeOutputStream, "StandardDataStore", '\n', '=', '.');
                    }
                    --n;
                }
                standardDataStore.needsWriting = false;
            }
            writeOutputStream.close();
            ((OutputStream)bufferedOutputStream).close();
        }
    }
}

