/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node.gui;

import Freenet.Params;
import Freenet.node.gui.Help;
import Freenet.node.gui.IntSetting;
import Freenet.node.gui.RadioSetting;
import Freenet.node.gui.SettingsPanel;
import Freenet.node.gui.StringSetting;

public class LoggingSettings
extends SettingsPanel {
    public LoggingSettings(Params params, Help help) {
        super("Logging");
        this.addHelp(help);
        this.addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
        RadioSetting radioSetting = new RadioSetting(params, help, "Logging level", "logging", "normal");
        radioSetting.add("error");
        radioSetting.add("normal");
        radioSetting.add("minor");
        radioSetting.add("debug");
        this.add(radioSetting);
        this.add(new StringSetting(params, help, "Log file", "logFile", "freenet.log"));
        this.add(new IntSetting(params, help, "Verbosity (1-5)", "verbosity", 4){

            protected boolean verifyValue(int n) {
                return n >= 1 && n <= 5;
            }
        });
    }

    public void addHelp(Help help) {
        help.add("logging", "Set what kind of events should be logged:\n Error:      Errors only\n Normal:     Report significant events\n Minor:      Report minor events\n Debug:  Report events only of relevance when debugging");
        help.add("logFile", "The name of the log file ('no' to log to standard out)");
        help.add("verbosity", "How verbose should the logging be.");
    }
}

