/*
 * Decompiled with CFR 0.152.
 */
package Freenet.node.gui;

import Freenet.Params;
import Freenet.node.gui.Help;
import Freenet.node.gui.IntSetting;
import Freenet.node.gui.SettingsPanel;

public class TimingSettings
extends SettingsPanel {
    public TimingSettings(Params params, Help help) {
        super("Timing");
        this.addHelp(help);
        this.addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
        this.add(new IntSetting(params, help, "Tick time", "tickerTime", 500L, "ms"));
        this.add(new IntSetting(params, help, "Hop time expected", "hopTimeExpected", 12000, "ms"));
        this.add(new IntSetting(params, help, "Hop time deviation", "hopTimeDeviation", 12000, "ms"));
        this.add(new IntSetting(params, help, "Authentication timeout", "authTimeout", 30000, "ms"));
        this.add(new IntSetting(params, help, "Connect timeout", "connectTimeout", 30000, "ms"));
        this.add(new IntSetting(params, help, "Handshake life", "handshakeLife", 10000000, "ms"));
        this.add(new IntSetting(params, help, "Handshake timeout", "handshakeTimeout", 30000, "ms"));
    }

    public void addHelp(Help help) {
        help.add("tickerTime", "The number of milliseconds between ticks on the timer");
        help.add("hopTimeExpected", "The expected time, in milliseconds, that it takes a Freenet node to pass a message. These are used to calculate how long the node should wait before assuming that a passed message is lost.  These are mostly here for debugging reasons - changing them will NOT make requests come back faster for you.");
        help.add("hopTimeDeviation", "The expected standard deviation, in milliseconds, that it takes a Freenet node to pass a message. These are used to calculate how long the node should wait before assuming that a passed message is lost.  These are mostly here for debugging reasons - changing them will NOT make requests come back faster for you.");
        help.add("authTimeout", "How long to wait for authentication before giving up.");
        help.add("connectTimeout", "How long to wait to connect to a host before giving up.");
        help.add("handshakeLife", "How long before a handshake expires.");
        help.add("handshakeTimeout", "How long before a handshake times out.");
    }
}

