/*
 * Decompiled with CFR 0.152.
 */
package Freenet.presentation;

import Freenet.Address;
import Freenet.BadAddressException;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.RawMessage;
import Freenet.support.Fields;
import Freenet.support.Logger;
import Freenet.support.io.ReadInputStream;
import Freenet.support.io.WriteOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FNPRawMessage
extends RawMessage {
    public static void main(String[] stringArray) throws Exception {
        FNPRawMessage fNPRawMessage = new FNPRawMessage(System.in);
        System.out.println(fNPRawMessage);
        ((RawMessage)fNPRawMessage).writeMessage(System.out);
    }

    public FNPRawMessage(InputStream inputStream) throws InvalidMessageException, EOFException {
        Core.logger.log(this, "Reading message", Logger.DEBUGGING);
        ReadInputStream readInputStream = new ReadInputStream(inputStream);
        this.fs = new FieldSet();
        try {
            this.messageType = readInputStream.readToEOF('\n', '\r');
            this.trailingFieldName = this.fs.parseFields(readInputStream, '\n', '\r', '=', '.');
            this.setFields(readInputStream);
        }
        catch (EOFException eOFException) {
            if (this.messageType != null) {
                Core.logger.log(this, "Stream died while reading message of type: " + this.messageType, Logger.ERROR);
            } else {
                Core.logger.log(this, "Stream closed", Logger.DEBUGGING);
            }
            throw eOFException;
        }
        catch (IOException iOException) {
            throw new EOFException("Could not parse message from stream : " + iOException);
        }
        catch (Exception exception) {
            Core.logger.log(this, "Exception in RawMessage()", Logger.ERROR);
            exception.printStackTrace();
        }
    }

    private void setFields(ReadInputStream readInputStream) {
        String string;
        String string2;
        String string3 = this.fs.get("KeepAlive");
        boolean bl = this.keepAlive = string3 == null || Fields.stringToBool(string3, true);
        if (string3 != null) {
            this.fs.remove("KeepAlive");
        }
        this.persist = (string2 = this.fs.get("Persist")) == null ? 0 : (Fields.stringToBool(string2, false) ? 1 : -1);
        String string4 = this.fs.get("Source");
        this.fs.remove("Source");
        if (string4 != null && !"".equals(string4)) {
            try {
                this.source = new Address(string4);
            }
            catch (BadAddressException badAddressException) {
                this.source = null;
            }
        } else {
            this.source = null;
        }
        long l = this.trailingFieldLength = (string = this.fs.get("DataLength")) == null ? 0L : Fields.stringToLong(string);
        if (string != null) {
            this.fs.remove("DataLength");
        }
        if (this.trailingFieldLength != 0L) {
            this.trailingFieldStream = readInputStream;
        } else {
            this.trailingFieldName = null;
        }
    }

    protected FNPRawMessage(String string, Address address, boolean bl, FieldSet fieldSet, long l, String string2, InputStream inputStream) {
        super(string, address, bl, 0, fieldSet == null ? new FieldSet() : fieldSet, l, string2, inputStream);
    }

    public void writeMessage(OutputStream outputStream) throws IOException {
        WriteOutputStream writeOutputStream = new WriteOutputStream(outputStream);
        writeOutputStream.writeUTF(this.messageType, '\n');
        if (this.source != null) {
            this.fs.add("Source", this.source.toString());
        }
        if (!this.keepAlive) {
            this.fs.add("KeepAlive", Fields.boolToString(this.keepAlive));
        }
        if (this.persist != 0) {
            this.fs.add("Persist", Fields.boolToString(this.persist > 0));
        }
        if (this.trailingFieldLength != 0L) {
            this.fs.add("DataLength", Fields.longToString(this.trailingFieldLength));
        }
        this.fs.writeFields(writeOutputStream, this.trailingFieldName == null ? "EndMessage" : this.trailingFieldName, '\n', '=', '.');
        writeOutputStream.flush();
    }

    public String toString() {
        return this.messageType + "\n" + "{Source=" + this.source + ",KeepAlive=" + this.keepAlive + ",DataLength=" + this.trailingFieldLength + "," + this.fs.toString() + "}";
    }
}

