/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support;

import Freenet.support.Logger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class StandardLogger
extends Logger {
    public static int TRACE = 7;
    public static int LOUD = 5;
    public static int COMPLETE = 4;
    public static int DETAILED = 3;
    public static int SPECIFIED = 2;
    public static int SPARSE = 1;
    protected static DateFormat df = DateFormat.getDateTimeInstance();
    public PrintStream lout;

    public StandardLogger(String string, int n, int n2) throws IOException {
        this.lout = new PrintStream(new FileOutputStream(string, true));
        this.verbosity = n;
        this.threshold = n2;
    }

    public StandardLogger(OutputStream outputStream, int n, int n2) throws IOException {
        this.lout = new PrintStream(outputStream);
        this.verbosity = n;
        this.threshold = n2;
    }

    public StandardLogger(PrintStream printStream, int n, int n2) {
        this.lout = printStream;
        this.verbosity = n;
        this.threshold = n2;
    }

    public void log(Object object, String string, int n) {
        if (n >= this.threshold) {
            String string2 = StandardLogger.priorityOf(n);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = "";
            if (this.verbosity > DETAILED) {
                string3 = string3 + df.format(new Date()) + ":";
            }
            if (this.verbosity > SPARSE) {
                string3 = string3 + (object == null ? "" : object.getClass().getName() + ":");
            }
            if (this.verbosity > COMPLETE) {
                string3 = string3 + (object == null ? "" : object.hashCode() + ":");
            }
            if (this.verbosity > SPECIFIED) {
                string3 = string3 + string2 + ":";
            }
            string3 = string3 + string;
            if (this.verbosity > LOUD || this.verbosity > COMPLETE && n >= Logger.ERROR) {
                new Exception(string3).printStackTrace(this.lout);
            } else {
                this.lout.println(string3);
                this.lout.flush();
            }
        }
    }

    public PrintStream getOut() {
        return this.lout;
    }

    public void setOut(PrintStream printStream) {
        this.lout = printStream;
    }

    public static int priorityOf(String string) {
        if (string.equalsIgnoreCase("error")) {
            return Logger.ERROR;
        }
        if (string.equalsIgnoreCase("normal")) {
            return Logger.NORMAL;
        }
        if (string.equalsIgnoreCase("minor")) {
            return Logger.MINOR;
        }
        if (string.equalsIgnoreCase("debugging")) {
            return Logger.DEBUGGING;
        }
        if (string.equalsIgnoreCase("debug")) {
            return Logger.DEBUGGING;
        }
        return Logger.NORMAL;
    }

    public static String priorityOf(int n) {
        String string = null;
        if (n == Logger.ERROR) {
            string = "Error";
        }
        if (n == Logger.NORMAL) {
            string = "Normal";
        }
        if (n == Logger.MINOR) {
            string = "Minor";
        }
        if (n == Logger.DEBUGGING) {
            string = "Debug";
        }
        return string;
    }
}

