/*
 * Decompiled with CFR 0.152.
 */
package Freenet.support.io;

import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.PadOnErrorInputStream;
import Freenet.support.io.VerifyingInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ControlInputStream
extends VerifyingInputStream {
    private static byte OK = 0;
    private long partLength;
    private long pbytesRead = 0L;
    private boolean streamDead = false;
    private int endChar = -1;
    private int endsWith = -1;

    public ControlInputStream(InputStream inputStream, long l, long l2) {
        super(inputStream, l2);
        this.partLength = l;
        if (inputStream instanceof PadOnErrorInputStream) {
            ((PadOnErrorInputStream)inputStream).setCIS(this);
        }
    }

    protected void checkPart(int n) throws IOException, DataNotValidIOException {
        this.pbytesRead = 0L;
        --this.bytesRead;
        if (this.endChar != -1) {
            throw new DataNotValidIOException(this.endChar);
        }
        if (n == -1) {
            throw new EOFException("Premature end-of-stream");
        }
        if (n != OK) {
            throw new DataNotValidIOException(n);
        }
    }

    public int read() throws IOException, DataNotValidIOException {
        int n;
        if (this.streamDead) {
            throw new EOFException("Already closed");
        }
        if (this.endsWith != -1) {
            this.checkPart(this.endsWith);
            return this.endsWith;
        }
        int n2 = n = this.partLength == 0L ? super.read() : this.priv_read();
        if (n != -1 && this.finished) {
            this.checkPart(n);
        }
        return n;
    }

    private int priv_read() throws IOException, DataNotValidIOException {
        int n = super.read();
        if (n != -1) {
            ++this.pbytesRead;
            if (this.pbytesRead == this.partLength) {
                this.checkPart(super.read());
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        int n3;
        if (this.streamDead) {
            throw new EOFException("Already closed");
        }
        if (this.endsWith != -1) {
            this.checkPart(this.endsWith);
            byArray[n] = (byte)this.endsWith;
            return 1;
        }
        if (n2 == 1) {
            byArray[n] = (byte)this.priv_read();
            if (this.finished) {
                this.checkPart(byArray[n] & 0xFF);
            }
            return 1;
        }
        int n4 = n3 = this.partLength == 0L ? super.read(byArray, n, n2) : this.priv_read(byArray, n, n2 - 1);
        if (n3 != -1) {
            if (n3 == 0) {
                return n2 == 0 ? 0 : this.read(byArray, n, n2);
            }
            if (this.finished) {
                if (n3 == 1) {
                    this.checkPart(byArray[n + n3 - 1] & 0xFF);
                } else {
                    this.endsWith = byArray[n + n3 - 1] & 0xFF;
                    --n3;
                }
            }
        }
        return n3;
    }

    int priv_read(byte[] byArray, int n, int n2) throws IOException, DataNotValidIOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = -1;
        boolean bl = false;
        if (this.pbytesRead == this.partLength) {
            int n4 = super.read();
            if (n4 == -1) {
                throw new EOFException("EOF where control byte expected");
            }
            this.checkPart(n4);
            byArray[n] = (byte)n4;
            ++n;
            --n2;
            bl = true;
            this.pbytesRead = 0L;
        }
        if ((long)n2 + this.pbytesRead >= this.partLength) {
            n2 = (int)(this.partLength - this.pbytesRead);
        }
        if ((n3 = super.read(byArray, n, n2)) != -1) {
            this.pbytesRead += (long)n3;
        } else {
            throw new EOFException("Unexpected EOF");
        }
        if (bl) {
            ++n3;
        }
        return n3;
    }

    public void close() throws IOException {
        if (this.streamDead) {
            throw new IOException();
        }
        this.streamDead = true;
        super.close();
    }

    public void endWithNextControl(int n) {
        if (n < 0 || n > 255) {
            throw new IndexOutOfBoundsException("Control char must be between 0 and 255");
        }
        this.endChar = n;
    }

    public static void main(String[] stringArray) throws IOException {
        ControlInputStream controlInputStream = new ControlInputStream(System.in, 0L, Integer.parseInt(stringArray[0]));
        byte[] byArray = new byte[1024];
        boolean bl = false;
        while (true) {
            int n;
            if ((n = controlInputStream.read(byArray, 0, 1024)) != -1) {
                System.out.write(byArray, 0, n);
                continue;
            }
            System.out.flush();
            System.exit(0);
        }
    }

    class EndWithNextControlIOException
    extends IOException {
        protected byte cb;

        public EndWithNextControlIOException(byte by) {
            this.cb = by;
        }

        public byte getCode() {
            return this.cb;
        }
    }
}

