/*
 * Decompiled with CFR 0.152.
 */
package Freenet.thread;

import Freenet.thread.ERunnable;
import Freenet.thread.ThreadManager;
import Freenet.thread.ThreadPool;

public class EThread
implements Runnable {
    protected Runnable code;
    protected ThreadManager host;
    protected Thread executor;

    public EThread(ThreadPool threadPool) {
        this.host = threadPool;
    }

    public Thread getThread() {
        return this.executor;
    }

    public ThreadManager getHost() {
        return this.host;
    }

    protected void begin() {
        if (this.executor == null) {
            this.executor = new Thread(this);
            this.executor.start();
        }
        EThread eThread = this;
        synchronized (eThread) {
            this.notifyAll();
        }
    }

    protected void setCode(Runnable runnable) {
        this.code = runnable;
    }

    public void run() {
        while (this.code == null) {
            EThread eThread = this;
            synchronized (eThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.code instanceof ERunnable) {
            ((ERunnable)this.code).setExecutionInstance(this);
        }
        try {
            this.code.run();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.code = null;
            this.host.reclaim(this);
            throw throwable;
        }
    }

    public String toString() {
        return "EThread[" + this.executor + ',' + this.code + ',' + this.host + ']';
    }
}

