/*
 * Decompiled with CFR 0.152.
 */
package Freenet.thread;

import Freenet.support.BlockingQueue;
import Freenet.support.BlockingStack;
import Freenet.thread.EThread;
import Freenet.thread.ThreadManager;

public class ThreadPool
extends Thread
implements ThreadManager {
    protected int maxThreads;
    protected int maxJobs;
    protected int maxPoolThreads;
    protected BlockingQueue jobs;
    protected BlockingStack threads;
    protected boolean run = true;

    public ThreadPool(int n) {
        this(5, n, Integer.MAX_VALUE);
    }

    public ThreadPool(ThreadGroup threadGroup, int n) {
        this(threadGroup, 5, n, Integer.MAX_VALUE);
    }

    public ThreadPool(int n, int n2, int n3) {
        this(Thread.currentThread().getThreadGroup(), n, n2, n3);
    }

    public ThreadPool(ThreadGroup threadGroup, int n, int n2, int n3) {
        super(threadGroup, "ThreadPool");
        this.setDaemon(true);
        this.jobs = new BlockingQueue();
        this.threads = new BlockingStack();
        this.maxPoolThreads = n;
        this.maxThreads = n2;
        this.maxJobs = n3;
        this.fillThreadstack();
    }

    private void fillThreadstack() {
        while (this.threads.size() < this.maxThreads) {
            this.threads.push(new EThread(this));
        }
    }

    public void reclaim(EThread eThread) {
        if (this.maxThreads > 0 || this.threads.size() < this.maxPoolThreads) {
            this.threads.push(eThread);
        }
        BlockingStack blockingStack = this.threads;
        synchronized (blockingStack) {
            this.threads.notifyAll();
        }
    }

    private int runningThreads() {
        return this.maxThreads - this.threads.size();
    }

    public boolean run(Runnable runnable) {
        if (this.run && this.runningThreads() + this.jobs.size() < this.maxJobs) {
            this.jobs.enqueue(runnable);
            return true;
        }
        return false;
    }

    public void blockingRun(Runnable runnable) {
        if (this.run) {
            while (this.runningThreads() + this.jobs.size() >= this.maxJobs) {
                BlockingStack blockingStack = this.threads;
                synchronized (blockingStack) {
                    try {
                        this.threads.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.jobs.enqueue(runnable);
        }
    }

    public void flush() {
        while (!this.jobs.isEmpty()) {
            BlockingQueue blockingQueue = this.jobs;
            synchronized (blockingQueue) {
                try {
                    this.jobs.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void halt() {
        this.run = false;
        this.interrupt();
    }

    public void run() {
        while (this.run) {
            try {
                EThread eThread = null;
                eThread = this.maxThreads > 0 || !this.threads.isEmpty() ? (EThread)this.threads.pop() : new EThread(this);
                Runnable runnable = (Runnable)this.jobs.dequeue();
                eThread.setCode(runnable);
                eThread.begin();
                BlockingQueue blockingQueue = this.jobs;
                synchronized (blockingQueue) {
                    this.jobs.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

