/*
 * Decompiled with CFR 0.152.
 */
package Freenet.transport;

import Freenet.Address;
import Freenet.ConnectException;
import Freenet.ConnectTimedOutException;
import Freenet.Connection;
import Freenet.Core;
import Freenet.ListeningAddress;
import Freenet.support.Logger;
import Freenet.support.io.ThrottledOutputStream;
import Freenet.transport.tcpAddress;
import Freenet.transport.tcpListeningAddress;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class tcpConnection
extends Connection {
    protected Socket sock = null;

    public String toString() {
        return this.getPeerAddress().toString();
    }

    public tcpConnection(tcpAddress tcpAddress2) throws UnknownHostException, IOException, ConnectException {
        ConnectThread connectThread = new ConnectThread(tcpAddress2);
        connectThread.start();
        long l = 0L;
        while (l < (long)Core.connectTimeout && !connectThread.done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            l += 100L;
        }
        if (this.sock == null) {
            connectThread.timedOut();
            if (connectThread.exception == null) {
                throw new ConnectTimedOutException();
            }
            throw new ConnectException(connectThread.exception.toString());
        }
        this.in = this.sock.getInputStream();
        if (this.sock.getLocalAddress().equals(this.sock.getInetAddress())) {
            Core.logger.log(this, "not throttling local connection", Logger.DEBUG);
            this.out = this.sock.getOutputStream();
        } else {
            this.out = ThrottledOutputStream.throttledStream(this.sock.getOutputStream());
        }
    }

    public tcpConnection(Socket socket) throws IOException {
        this.sock = socket;
        this.in = socket.getInputStream();
        if (socket.getLocalAddress().equals(socket.getInetAddress())) {
            Core.logger.log(this, "not throttling local connection", Logger.DEBUG);
            this.out = socket.getOutputStream();
        } else {
            this.out = ThrottledOutputStream.throttledStream(socket.getOutputStream());
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out = null;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSoTimeout(int n) throws IOException {
        if (this.sock == null) {
            throw new IOException();
        }
        this.sock.setSoTimeout(n);
    }

    public int getSoTimeout() throws IOException {
        return this.sock.getSoTimeout();
    }

    public Address getMyAddress(ListeningAddress listeningAddress) {
        return this.sock == null ? null : new Address("tcp", new tcpAddress(this.sock.getLocalAddress(), ((tcpListeningAddress)listeningAddress.address).port));
    }

    public Address getMyAddress() {
        return this.sock == null ? null : new Address("tcp", new tcpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort()));
    }

    public Address getPeerAddress(ListeningAddress listeningAddress) {
        return this.sock == null ? null : new Address("tcp", new tcpAddress(this.sock.getInetAddress(), ((tcpListeningAddress)listeningAddress.address).port));
    }

    public Address getPeerAddress() {
        return this.sock == null ? null : new Address("tcp", new tcpAddress(this.sock.getInetAddress(), this.sock.getPort()));
    }

    private class ConnectThread
    extends Thread {
        public boolean done;
        private boolean abandoned = false;
        public Exception exception = null;
        private tcpAddress tcpaddr;

        public ConnectThread(tcpAddress tcpAddress2) {
            this.setName("tcpConnectThread");
            this.tcpaddr = tcpAddress2;
        }

        public void run() {
            try {
                tcpConnection.this.sock = new Socket(this.tcpaddr.host, this.tcpaddr.port);
            }
            catch (IOException iOException) {
                tcpConnection.this.sock = null;
                this.exception = iOException;
            }
            this.done = true;
            if (tcpConnection.this.sock != null && this.abandoned) {
                try {
                    tcpConnection.this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void timedOut() {
            this.abandoned = true;
        }
    }
}

