package Freenet;
//import java.net.*;
import Freenet.support.Loader;
import java.lang.reflect.*;
import java.io.Serializable;


public class Address implements Serializable
{
    public String protocol;
    public ProtocolAddress address;

    /**
     * Constructs a new address for a protocol name and protocol specific
     * Address.
     **/
  public Address(String protocol, ProtocolAddress addr)
    {
      this.protocol = protocol;
      this.address = addr;
    }

    /**
     * Constructs a new address by reading the string in the form 
     * <transport>/<address name>
     * @param str   The characters preceding the slash are considered the 
     *              protocol name, and the constuctor will attempt to make
     *              a ProtocolAddress by constructing a class  
     *              Freenet.transport.<transport>Address with the substring
     *              subceding the slash as the argument.
     * @exception BadAddressException - if the string cannot be parsed, or 
     *            constructing the ProtocolAddress fails.
     **/
    public Address(String str) throws BadAddressException
    {
	this(tsplit(str),asplit(str));
    }
    public static String tsplit(String str) throws BadAddressException {
	int i = str.indexOf('/');
	if (i < 1)
	    throw new BadAddressException
		("Protocol not specified in address `" + str + "'");
	return str.substring(0,i);
    }
    public static String asplit(String str) {
	int i = str.indexOf('/');
	return str.substring(i+1,str.length());
    }

    /**
     * Constructs a new address by reading the string in the form 
     * <transport>/<address name>
     * @param transport  The name of the transport used.
     * @param addr  This he constuctor will attempt to make
     *              a ProtocolAddress by constructing a class  
     *              Freenet.transport.<transport>Address with this string
     *              as the argument.
     * @exception BadAddressException - if constructing the ProtocolAddress 
     *            fails.
     **/
    public Address(String transport, String addr) throws BadAddressException {
	protocol = transport;
	String addressClass = "Freenet.transport." + transport + "Address";

	try {
	    address = 
		(ProtocolAddress)Loader.getInstance(addressClass,
						    new Class[] {String.class},
						    new Object[] {addr});
	} catch (ClassNotFoundException e) {
	    throw new BadAddressException
		("Unknown protocol `" + protocol + "' in address");
	} catch (NoSuchMethodException e) {
	    throw new BadAddressException
		("No constructor found for class " + addressClass);
	} catch (InstantiationException e) {
	    throw new BadAddressException
		("Could not instantiate class " + addressClass);
	}	catch (IllegalAccessException e) {
	    throw new BadAddressException
		("IllegalAccessException while instantiating class "
		 + addressClass);
	} catch(InvocationTargetException e) {
	    if (e.getTargetException() instanceof IllegalArgumentException) {
		throw new BadAddressException(e.getTargetException().toString());
	    }
	    else if (e.getTargetException() instanceof BadAddressException) {
		throw (BadAddressException) e.getTargetException();
	    }
	    e.getTargetException().printStackTrace();
      }
 }

    /**
     * Return the string name of the transport used.
     **/
    public String transport() { 
	return protocol;
    }

    /**
     * Return the transport specific ProtocolAddress object.
     **/
    public ProtocolAddress address() {
	return address;
    }

    public String toString()
    {
      return protocol+"/"+address;
    }

  public int hashCode()
  {
    return toString().hashCode();
  }

    /**
     * Returns the part of this address that differentiates several nodes
     * on the same entity on the network.
     **/
    public ListeningAddress listenPart() {
	return new ListeningAddress(protocol,address.listenPart());
    }

  public boolean equals(Object o)
    {
	return ((o instanceof Address) &&
	       	(((Address) o).protocol.equals(protocol)) &&
	       	(((Address) o).address.equals(address)));

    }

    /**
     * Checks if two addresses reside on the same entity (host) on the network.
     * In other words, if only the part described by ListeningAddress differs.
     **/
    public boolean equalsHost(Object o)
    {
	return ((o != null) &&
		(o instanceof Address) &&
		((Address) o).protocol.equals(protocol) &&
		((Address) o).address.equalsHost(address));
    }
}




