package Freenet;
import java.io.*;

/**
 * A wrapping exception that a Conduit feed sends it's MessageObject
 * if the feed should fail do to an IOException.
 *
 * @author oskar
 **/

public class ConduitException extends Exception {

    private IOException occured;
    private InputStream in;
    private OutputStream out;
    private boolean inRead;
    private long bytesMoved;

    /**
     * Create a new Conduit Exception.
     * @param occured  The IOException that occured 
     * @param in       The InputStream from which the conduit was reading.
     * @param out      The OutputStream tp which the conduit was writing.
     * @param inRead   true if the exception occured during reading, false
     *                 if it occured during writing.
     * @param bytesMoved  The number of bytes already read and written when
     *                    the exception occured.
     **/
    public ConduitException(IOException occured, InputStream in, 
			    OutputStream out, boolean inRead, 
			    long bytesMoved) {
	this.occured = occured;
	this.in = in;
	this.out = out;
	this.inRead = inRead;
	this.bytesMoved = bytesMoved;
    }

    /**
     * @return the Exception that occured.
     **/
    public IOException getIOException() {
	return occured;
    }

    /**
     * @return the InputStream
     **/
    public InputStream getInStream() {
	return in;
    }

    /**
     * @return the OutputStream
     **/
    public OutputStream getOutStream() {
	return out;
    }

    /**
     * The number of bytes that had been moved when the exception occured.
     * @return  The number set as the bytesMoved argument on creation
     */
    public long bytesMoved() {
	return bytesMoved;
    }

    /**
     * @return True if the exception occured during read, false if it 
     *         occured during write.
     **/ 
    public boolean inRead() {
	return inRead;
    }

    public String toString() {
	return "Exception: " + occured.toString() + " thrown during " + (inRead ? "read" : "write") + " of Conduit feed";
    }
}





