package Freenet;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public abstract class Connection
{
    protected boolean initialized=false;
    public Object initLock=new Object();

    /**
     * The input stream of this connection
     **/
    public InputStream in;
    /**
     * The output stream of this connection
     **/
    public OutputStream out;
    /**
     * Generic object containing info about this
     * Connection, for use by the protocol
     **/
    public Object info;
    /**
     * Closes the connection
     **/
    public abstract void close();
    /**
     * Sets the amount of time a read off this connection should
     * lock before timing out. 
     * @param timeout The time in milliseconds. Zero means no timeout
     **/
    public abstract void setSoTimeout(int timeout) throws IOException;

    /**
     * Gets the amount of time a read off this connection should
     * lock before timing out. 
     **/
    public abstract int getSoTimeout() throws IOException;

     /**
     * Get the full address of this connection of the listener
     * this connection is from.
     * @param  lstaddr  The ListeningAddress of the listener.
     * @return          The full address of the Listener.
     **/
    public abstract Address getMyAddress(ListeningAddress lstaddr);
    /**
     * Get the full address of the listener this connection is from. 
     * @return     A full address. The Listening part of the address
     *             does not have to be correct for outgoing connections.   
     **/
    public abstract Address getMyAddress();
    /**
     * Get the full address of this connection of the listener
     * this connection is to.
     * @param  lstaddr  The ListeningAddress of the listener.
     * @return          The full address of the Listener.
     **/
    public abstract Address getPeerAddress(ListeningAddress lstaddr);
    /**
     * Get the full address of the listener this connection is to. 
     * @return     A full address. The Listening part of the address
     *             does not have to be correct for incoming connections.
     **/
    public abstract Address getPeerAddress();

    /**
     * Returns true if limits to the number of connections 
     * should be ignored for for this connection.
     */
    public abstract boolean privileged();

    /**
     * Returns true if the connection is fully set up and ready to
     * be used
     */
    public boolean ready() {
	return initialized;
    }

    /**
     * Called when a presentation deems the connection ready
     */
    public void setReady() {
	initialized=true;
    }


}
