package Freenet;
import Freenet.support.Loader;
import java.lang.reflect.*;
//import java.net.*;

public class ListenerFactory
{
  static public Listener listen(String str) throws ListenException
  {
    return listen(new ListeningAddress(str));
  }

  static public Listener listen(ListeningAddress address) throws ListenException
  {
      // find classes to load
      String listenerClass = "Freenet.transport." + address.protocol + 
	  "Listener";

      try {
	  return (Listener)
	      Loader.getInstance(listenerClass,
				 new Class[] {address.address.getClass()},
				 new Object[] {address.address});
      }
      catch (ClassNotFoundException e) {
	  throw new RuntimeException
	      ("Unknown protocol `" + address.protocol + "' in address");
      }
      catch (NoSuchMethodException e) {
	  throw new RuntimeException
	      ("No constructor found for class " + listenerClass);
      }
      catch (InstantiationException e) {
	  throw new RuntimeException
	      ("Could not instantiate class " + listenerClass);
      }	  
      catch (IllegalAccessException e) {
	  throw new RuntimeException
	      ("Encountered IllegalAccessException while instantiating class "
	       + listenerClass);
      }	  
      catch(InvocationTargetException e) {
	  if (e.getTargetException() instanceof ListenException)
	      throw (ListenException) e.getTargetException();
	  e.getTargetException().printStackTrace();
	  return null;
      }
  }
}




