package Freenet;
import Freenet.support.Loader;
import java.lang.reflect.*;

public class ListeningAddress {
    public String protocol;
    public ProtocolListeningAddress address;

    public ListeningAddress(String prot, ProtocolListeningAddress addr) {
	protocol = prot;
	address = addr;
    }

    public ListeningAddress(String str) {
	// find class to load
	int i = str.indexOf('/');
	if (i == -1) throw new IllegalArgumentException();
	protocol = str.substring(0,i);
	String listeningAddressClass = "Freenet.transport." + protocol
	    + "ListeningAddress";

	try {
	    address = (ProtocolListeningAddress)
		Loader.getInstance(listeningAddressClass,
				   new Class[] {java.lang.String.class},
				   new Object[] {str.substring(i+1)});
	}
	catch (ClassNotFoundException e) {
	    throw new RuntimeException
		("Unknown protocol `" + protocol + "' in address");
	}
	catch (NoSuchMethodException e) {
	    throw new RuntimeException
		("No constructor found for class " + listeningAddressClass);
	}
	catch (InstantiationException e) {
	    throw new RuntimeException
		("Could not instantiate class " + listeningAddressClass);
	}	  
	catch (IllegalAccessException e) {
	    throw new RuntimeException
		("Encountered IllegalAccessException while instantiating class "
		 + listeningAddressClass);
	}
	catch(InvocationTargetException e) {
	    if (e.getTargetException() instanceof IllegalArgumentException)
		throw (IllegalArgumentException) e.getTargetException();
	    e.getTargetException().printStackTrace();
	}
    }

    public String toString() {
	return protocol+"/"+address;
    }
}
