package Freenet;

import java.lang.reflect.*;
import java.io.*;
import java.util.Hashtable;
import Freenet.support.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * MessageFactory.java
 *
 * This object takes a RawMessage and converts it to the appropriate 
 * subclass of the Message class depending on the message.
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

public class MessageFactory
{
    public static Message toMessage(RawMessage r) 
	throws InvalidMessageException {
	try {
	  
	    Class c=Loader.load("Freenet.message." + r.messageType.replace('.',
									   '_'));
	    Class[] carr={Freenet.RawMessage.class};
	    Object[] oarr={r};
	    Constructor con=c.getConstructor(carr);
	    Message m=(Message)con.newInstance(oarr);
	    return m;
	    
	} catch(InvocationTargetException e) {
	    if (e.getTargetException() instanceof InvalidMessageException)
		throw (InvalidMessageException) e.getTargetException();
	    else {
		Core.logger.log(null,"MessageFactory.java, Message constructor threw exception:" + e.getTargetException(),Logger.ERROR);
		throw new InvalidMessageException("Message constructor threw unkown exception.");
	    }
	} catch(ClassNotFoundException e) {
	    Core.logger.log(null,"MessageFactory.java, Unknown messagetype - "+e,Logger.NORMAL);
	    throw new InvalidMessageException("Message type not recognized");
	} catch(Exception e) {
	    Core.logger.log(null,"MesageFactory threw " + e, Logger.ERROR);
	    throw new InvalidMessageException("Unknown Error");
	}
    }
}







