package Freenet;
import Freenet.support.Callback;
import Freenet.support.ExceptionCallback;

/**
 * This allows a MessageObject to be wrapped so it can be called as 
 * a callback. Callbacks are the old way of doing events, we don't like
 * them, so please use on MessageObjects where possible.
 * 
 * @author oskar
 **/

public class MessageObjectCB implements ExceptionCallback, Callback {

    private MessageHandler mh;
    private MessageObject mo;

    public MessageObjectCB(MessageHandler mh, MessageObject mo) {
	this.mh = mh;
	this.mo = mo;
    }

    public void callback() {
	mh.handle(mo);
    }

    public void callback(Exception e) {
	mo.setException(e);
	mh.handle(mo);
    }

}
