package Freenet;
import Freenet.support.*;
import Freenet.node.Node;
import Freenet.thread.ThreadManager;
import java.util.Vector;
import java.util.Enumeration;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This class sends MessageObjects to a MessageHandler after a specified
 * amout on time. 
 *
 * It's now based on a heap (so it should be pretty fast), but you have to
 * handle keeping track of objects you may wish to cancel yourself 
 * (I didn't want another fucking hashtable). Since this makes it 
 * Freenet specific, I'm moving it to the root (and Freenet's main instance.
 * of it is an instance, rather than a static, varibale in Freenet.Core).
 *
 * @author oskar
 */

// Ians javadoc for the old ticker.
/* 
 * This class allows a callback to be called after a specified
 * amount of time.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 */

public class Ticker extends Thread {
    // Protected/Private Fields
    public Vector events;

    private long ticker;
    private MessageHandler mh;
    private ThreadManager tm;
  
    /**
     * Construct a Ticker with a tick time of 100 milliseconds.
     * @param mh  The MessageHandler to send events to.
     * @param tm  A ThreadManager to get threads to handle events in from.
     *            If this is null, new threads will be created manually for
     *            each event.
     **/
    public Ticker(MessageHandler mh, ThreadManager tm) {
	this(mh, tm, (long) 100);
    }

    /**
     * Set the ticker time
     * @param ms The time between ticks in ms
     */
    public void setTickerTime(long ms) {
	ticker=ms;
    }

    /**
     * Construct a Ticker with the given tick time in milliseconds.
     * @param mh     The MessageHandler to send events to.
     * @param tm  A ThreadManager to get threads to handle events in from.
     *            If this is null, new threads will be created manually for
     *            each event.
     * @param ticker The time to wait (in milliseconds) between 
     *               testing whether a callback should be called.
     **/
    public Ticker(MessageHandler mh, ThreadManager tm, long ticker)
    {
	super("Ticker");
	this.mh = mh;
	this.ticker = ticker;
	this.events = new Vector(50,20);
	this.tm = tm;
	events.addElement(new Object()); // add first dummy object
    }

    // Public Methods

    /**
     * Sets the MessageHandler to use.
     * @param mh   The MessageHandler that should handle MessageObjects
     *             from the Ticker.
     */
    public void setMessageHandler(MessageHandler mh) {
	this.mh = mh;
    }

    /**
     * Schedules a MessageObject.
     * @param time The time to wait (in milliseconds) before handeling the 
     *             MessageObject. If the MessageObject implements the 
     *             Schedulable interface, then it will be given a TickerToken
     *             it can use to cancel itself.
     * @param cb   The MessageObject to execute.
     * @see Schedulable
     **/
    public void add(long time, MessageObject mo) {
	time += System.currentTimeMillis();
	Event evt = new Event(mo, time);
	if (mo instanceof Schedulable) {
	    ((Schedulable) mo).getToken(evt);
	}
	events.addElement(evt); // just to increase the size
	int i = events.size() - 1; 
	Event tmp;


	while (i > 1 &&
	       evt.time() < ((Event) events.elementAt(i >> 1)).time()) {
	    //	    System.out.println(i);
	    tmp = (Event) events.elementAt(i >> 1);
	    tmp.setPos(i);
	    events.setElementAt(tmp, i);
	    i = i >> 1;
	}
	evt.setPos(i);
	events.setElementAt(evt,i);
    }

    public void run() {
	Core.logger.log(this,"Thread started",Logger.DEBUGGING);
	while(true) {
	    while (events.size() > 1 && 
		   first().time() <= System.currentTimeMillis()) {
		delete().execute();
	    }
	    try {
		sleep(ticker);
	    } catch (InterruptedException e) {
	    }
	}
    }

    public String toString() {
	StringBuffer sb = new StringBuffer();
	Enumeration e = events.elements();
	e.nextElement();
	while(e.hasMoreElements()) {
	    Event evt = (Event) e.nextElement();
	    sb.append(evt.time() + " - "+ evt.getOwner().id() + "\n");
	}
	return sb.toString();
    }

    public synchronized void remove(int i) {
	Event tmp = (Event) events.lastElement();
	((Event) events.elementAt(i)).setPos(0);
	events.removeElementAt(events.size() - 1);
	if (events.size() <= i)
	    return; // we were removing the very last element
	int child;
	Event childe;
	while(true) {
	    if (i << 1 > (events.size() - 1)) {
		break;
	    } else if (i << 1 > (events.size() - 2)) {
		child = i << 1;
	    } else {
		child = (((Event) events.elementAt(i << 1)).time() <
			 ((Event) events.elementAt((i << 1) + 1)).time() ?
			 i << 1 :
			 (i << 1) + 1);
	    }
	    if (((Event) events.elementAt(child)).time() >
		tmp.time()) {
		break;
	    } else {
		childe = (Event) events.elementAt(child);
		childe.setPos(i);
		events.setElementAt(childe,i);
		i = child;
	    }
	}
	tmp.setPos(i);
	events.setElementAt(tmp,i);
    }

    // Protected/Private Methods

    private Event first() {
	return events.size() == 1 ? null : (Event) events.elementAt(1); 
    }

    private synchronized Event delete() {
	if (events.size() == 1)
	    return null;
	Event r = (Event) events.elementAt(1);
	remove(1);

	return r;
    }

    private class Event implements Runnable, TickerToken {
	private boolean executed;
	private MessageObject mo;
	private long time;
	private int pos = 0;

	public Event(MessageObject mo, long time) {
	    this.mo = mo;
	    this.time = time;
	}

	public synchronized void execute() {
	    executed = true;
	    if (tm != null) {
		tm.blockingRun(this);
	    } else {
		(new Thread(this,"Scheduled MessageObject: " + mo)).start();
	    }
	}

	public boolean executed() {
	    return executed;
	}

	public synchronized boolean cancel() {
	    if (executed || pos == 0) {
		return false;
	    } else {
		Ticker.this.remove(pos);
		return true;
	    }
	}

	public synchronized void setPos(int pos) {
	    this.pos = pos;
	}

	public long time() {
	    return time;
	}

	public void run() {
	    mh.handle(mo);
	}

	public MessageObject getOwner() {
	    return mo;
	}
    }
}





