package Freenet.client;
import java.io.*;
import java.net.BindException;
//import java.net.*;
import Freenet.*;
import Freenet.support.*;
import Freenet.message.*;
import Freenet.presentation.FreenetProtocol;

/**
 * This is an implementation of Core the for use by the clients. It is 
 * runnable, and when started will listen for connections, feeding them
 * to a ClientMessageHandler.
 *
 * @author oskar
 **/

public class ClientCore extends Core {


    public ClientMessageHandler cmh;

    /* Clients are always static. */
    public boolean getTransience() {return true;}

    /**
     * Create a new ClientCore.
     * @param myAddress  The address (port) that this client should listen for
     *                   messages on.
     * @param t          The presentation protocol to use for this client.
     **/
    public ClientCore(ListeningAddress myAddress, Presentation t) 
	throws ListenException {
	super(myAddress,t, new StandardHandshakeHandler());
	this.cmh = new ClientMessageHandler(this);
    }

    /**
     * Starts the client listening for Connections and Messages.
     **/
    public void acceptConnections() {
	super.acceptConnections(cmh, true, false);
    }

    public String toString() {
	return "Client core on port " + myAddress;
    }
}
