package Freenet.client;

/**
 * Event handeling for clients.
 *
 * @author oskar
 **/
public interface ClientEventProducer {

    /**
     * Adds an EventListener that will receive all events produced
     * by the implementing object.
     * @param cel The ClientEventListener to add.
     **/
    public void addEventListener(ClientEventListener cel);

    /**
     * Removes an EventListener that will no loger receive events
     * produced by the implementing object.
     * @param cel  The ClientEventListener to remove.
     * @return     true if a Listener was removed, false otherwise.
     **/
    public boolean removeEventListener(ClientEventListener cel);

}
