package Freenet.client;

import Freenet.KeyException;
import java.io.IOException;

/** Part of a general API for Freenet clients, with optional metadata handling.
  * @author tavin
  */
public interface ClientFactory {

    /** Used to instantiate a Client to handle a request.
      * @param req  the request to process
      * @return     a Client instance for this request
      * @throws UnsupportedRequestException if the class of req is not
      *                                     supported in the implementation
      * @throws KeyException if the request URI contains an unsupported keytype
      * @throws IOException  if there is an I/O error
      */
    Client obtainClient(Request req)
        throws UnsupportedRequestException, KeyException, IOException;
}
