package Freenet.client;

import Freenet.KeyException;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.keys.KSK;
import Freenet.crypt.*;
import java.io.*;
import java.util.Random;

/**
 * ClientKey implemenation for KSKs
 *
 * @author sgm
 */
public class ClientKSK extends ClientSVK {

    public ClientKSK(FreenetURI key) throws KeyException {
	if (!key.getKeyType().equals("KSK"))
	    throw new KeyException("URI is not a KSK");
	keyData=key;
    }

    public ClientKSK(Random r, String keyword) throws KeyException {
	super(r);
	keyData=new FreenetURI("KSK",keyword,null, null);
    }

    public ClientKSK(Random r, FreenetURI key) throws KeyException {
	super(r);
	if (!key.getKeyType().equals("KSK"))
	    throw new KeyException("URI is not a KSK");
	keyData=key;
    }

    public byte[] getEncryptionKey(int keyLength) throws KeyException {
	byte[] bs = null;
	try {
	    bs = keyData.getGuessableKey().getBytes("UTF8");
	} catch (Exception e) { e.printStackTrace();}
	byte[] cryptoKey=new byte[keyLength];
	Util.makeKey(bs, cryptoKey, 0, cryptoKey.length);
	keyData=new FreenetURI(keyData.getKeyType(),
			       keyData.getGuessableKey(),
			       keyData.getKeyVal(),
			       cryptoKey);
	return cryptoKey;
    }
    
    public Key getKey() {
	key=KSK.makeKSK(keyData.getGuessableKey(), null);
	keyData=new FreenetURI(keyData.getKeyType(),
			       keyData.getGuessableKey(),
			       key.getVal(),
			       keyData.getCryptoKey());
	return key;
    }
    
    public Key getKey(FieldSet storables) {
	key=KSK.makeKSK(keyData.getGuessableKey(), storables);
	key.sign(contentHash, r, storables);
	keyData=new FreenetURI(keyData.getKeyType(),
			       keyData.getGuessableKey(),
			       key.getVal(),
			       keyData.getCryptoKey());
	return key;
    }

    public FreenetURI getURI() {
	return keyData;
    }

    public static void main(String[] args) throws Exception {
	ClientKSK s=new ClientKSK(new Yarrow(), args[0]);
	s.getKey();
	s.getEncryptionKey(16);
	System.err.println(s.getURI());
	FreenetURI n=new FreenetURI(s.getURI().toString());
	n.decompose();
    }

    public String toString() {
	return getURI().toString();
    }
}



	
	
