package Freenet.client;
import Freenet.*;
import Freenet.support.Bucket;
import Freenet.crypt.BlockCipher;
import java.io.InputStream;
import java.io.IOException;

/**
 * This defines an interface for Client key objects, used to generate Freenet
 * Keys for inserts.
 *
 * @author oskar
 **/
public interface ClientKey {

    /**
     * Returns the encryption key to use for encrypting this document. How
     * this is generated depends on the keytype, for some keys it may be
     * random, others dependant on some property set at construction.
     **/
    public byte[] getEncryptionKey(int keyLength) throws KeyException;

    /**
     * This produces an Inputstream of ciphertext from the document according
     * to this Key's protocol. In doing this the ClientKey implementation 
     * should also gather any information it may need about the data (such
     * as digest value).
     * @param doc the document that is being Inserted with the this key.
     * @param c   the cipher to send to the document for encrypting.
     * @param b   a bucket where to store the ciphertext in as it is being
     *            processed.
     **/
    public InputStream docToStream(Document doc, BlockCipher c, Bucket b) 
	throws IOException;

    /**
     * Returns the Key value of this object. Depending on the constructor 
     * this may rely on docToStream having been called and may return null 
     * if it hasn't.
     * @param storables  The storables FieldSet of the Insert message 
     *                   where key related meta-data will be added.
     * @return The Key for this object if it is known, otherwise null.
     **/
    public Key getKey(FieldSet storables);

    /**
     * Returns the Key value of this object. Depending on the constructor 
     * this may rely on docToStream having been called and may return null 
     * if it hasn't.
     * @return The Key for this object if it is known, otherwise null.
     **/
    public Key getKey();

    /**
     * The total data length.
     * @return The length of the total data if it is known, 0 otherwise.
     */
    public long getDataLength();

    /**
     * The length of the data minus all control characters.
     * @param length     The total length of the data.
     * @param storables  The storables fields returned.
     * @return The length of the plain data if it is known, 0 otherwise.
     */
    public long getPlainLength(long length, FieldSet storables);

    /**
     * The String URI of this Key
     * @return The URI of this Key if it is known, null otherwise.
     **/
    public FreenetURI getURI();
}





