package Freenet.client;

import Freenet.KeyException;
import Freenet.FieldSet;
import Freenet.Key;
import Freenet.keys.SVK;
import Freenet.keys.KSK;
import Freenet.crypt.*;
import java.io.*;
import java.util.Random;

/**
 * ClientKey implemenation for KSKs
 *
 * @author sgm
 */
public class ClientSSK extends ClientSVK {

    public ClientSSK(FreenetURI key) throws KeyException {
	if (!key.getKeyType().equals("SSK"))
	    throw new KeyException("URI is not a SSK");
	this.key=SVK.makeSVK(key.getKeyVal(), key.getGuessableKey());
	this.keyData=key;
    }

    public ClientSSK(Random r, FreenetURI key) throws KeyException {
	this.keyData=key;
	
	kp=new DSAKeyPair(Util.byteArrayToMPI(key.getKeyVal()),
			  Global.DSAgroupB);
	this.r=r;
	if (!key.getKeyType().equals("SSK"))
	    throw new KeyException("URI is not an SSK");
    }

    public byte[] getEncryptionKey(int keyLength) throws KeyException {
	byte[] bs = null;
	try {
	    bs = keyData.getGuessableKey().getBytes("UTF8");
	} catch (Exception e) { e.printStackTrace();}
	if (keyData.getCryptoKey()!=null) {
	    byte[] ckd=keyData.getCryptoKey();
	    if (ckd.length==0) {
		ckd=new byte[16];
		r.nextBytes(ckd);
		keyData=new FreenetURI(keyData.getKeyType(),
				       keyData.getGuessableKey(),
				       keyData.getKeyVal(),
				       ckd);
	    }

	    byte[] newbs=new byte[bs.length + keyData.getCryptoKey().length];
	    System.arraycopy(bs, 0, newbs, 0, bs.length);
	    System.arraycopy(keyData.getCryptoKey(), 0, newbs, bs.length, 
			     keyData.getCryptoKey().length);
	    bs=newbs;
	}
	byte[] cryptoKey=new byte[keyLength];
	Util.makeKey(bs, cryptoKey, 0, cryptoKey.length);
	return cryptoKey;
    }

    public Key getKey() {
	return key;
    }
    
    public Key getKey(FieldSet storables) {
	key=SVK.makeSVK(kp, keyData.getGuessableKey(), storables);
	key.sign(contentHash, r, storables);
	return key;
    }

    public FreenetURI getURI() {
	byte[] parent=null;
	if (kp!=null) {
	    parent=new byte[23];
	    byte[] pk=kp.fingerprint();
	    System.arraycopy(pk, 0, parent, 0, 20);
	    parent[20]=Key.lengthLimit(SVK.SVK_MAXSIZE);
	    parent[21]=(byte)(SVK.keyNumber >> 8);
	    parent[22]=(byte)SVK.keyNumber;
	}

	return new FreenetURI("SSK", keyData.getGuessableKey(), 
			      parent==null ? 
			      keyData.getKeyVal() : 
			      parent,
			      keyData.getCryptoKey());
    }
}



	
	
