package Freenet.client;

import Freenet.support.Bucket;

/** Represents a ComputeCHKRequest (GenerateCHK in FCP)
  * @author tavin
  */
public class ComputeCHKRequest extends Request {

    ClientCHK clientKey;
    Bucket meta, data, ctBucket;
    String cipherName;
    
    /**
      */
    public ComputeCHKRequest(String cipherName, Bucket meta,
                             Bucket data, Bucket ctBucket) {
        super();
        this.cipherName = (cipherName == null ? "Twofish" : cipherName);
        this.meta       = meta;
        this.data       = data;
        this.ctBucket   = ctBucket;
    }

    /** @return the generated URI or null if request incomplete
      */
    public FreenetURI getURI() {
        return clientKey == null ? null : clientKey.getURI();
    }

    boolean copyFrom(Request req) { return false; }
}
